/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon.spawner.tag.keys;

import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.dungeon.spawner.tag.TypeValuePair;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.Key;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParser;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserBase;
import com.stek101.projectzulu.common.dungeon.spawner.tag.settings.OptionalSettings;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class KeyParserGround
extends KeyParserBase {
    public KeyParserGround(Key key) {
        super(key, true, KeyParser.KeyType.CHAINABLE);
    }

    @Override
    public boolean parseChainable(String parseable, ArrayList<TypeValuePair> parsedChainable, ArrayList<OptionalSettings.Operand> operandvalue) {
        String[] pieces = parseable.split(",");
        OptionalSettings.Operand operand = this.parseOperand(pieces);
        if (pieces.length == 1) {
            parsedChainable.add(new TypeValuePair(this.key, this.isInverted(parseable)));
            operandvalue.add(operand);
            return true;
        }
        ProjectZuluLog.severe("Error Parsing Needs %s parameter. Invalid Argument Length.", this.key.key);
        return false;
    }

    @Override
    public boolean parseValue(String parseable, HashMap<String, Object> valueCache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValidLocation(World world, EntityLiving entity, int xCoord, int yCoord, int zCoord, TypeValuePair typeValuePair, HashMap<String, Object> valueCache) {
        boolean isInverted = (Boolean)typeValuePair.getValue();
        boolean canSeeSky = this.canBlockSeeTheSky(world, xCoord, yCoord, zCoord);
        return isInverted ? canSeeSky : !canSeeSky;
    }

    protected boolean canBlockSeeTheSky(World world, int xCoord, int yCoord, int zCoord) {
        int blockHeight = this.getTopSolidOrLiquidBlock(world, xCoord, zCoord);
        return blockHeight < 0 || blockHeight <= yCoord;
    }

    private int getTopSolidOrLiquidBlock(World world, int par1, int par2) {
        Chunk chunk = world.func_72938_d(par1, par2);
        par1 &= 0xF;
        par2 &= 0xF;
        for (int k = chunk.func_76625_h() + 15; k > 0; --k) {
            Block l = chunk.func_150810_a(par1, k, par2);
            if (l == null || !l.func_149688_o().func_76230_c() || l.func_149688_o() == Material.field_151584_j || l.func_149688_o() == Material.field_151575_d || l.func_149688_o() == Material.field_151592_s || l.isFoliage((IBlockAccess)world, par1, k, par2)) continue;
            return k + 1;
        }
        return -1;
    }
}

