/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon.spawner.tag.keys;

import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.dungeon.spawner.tag.ParsingHelper;
import com.stek101.projectzulu.common.dungeon.spawner.tag.TypeValuePair;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.Key;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParser;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserBase;
import com.stek101.projectzulu.common.dungeon.spawner.tag.settings.OptionalSettings;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.EntityLiving;
import net.minecraft.world.World;

public abstract class KeyParserRange
extends KeyParserBase {
    public KeyParserRange(Key key) {
        super(key, true, KeyParser.KeyType.CHAINABLE);
    }

    @Override
    public boolean parseChainable(String parseable, ArrayList<TypeValuePair> parsedChainable, ArrayList<OptionalSettings.Operand> operandvalue) {
        String[] pieces = parseable.split(",");
        OptionalSettings.Operand operand = this.parseOperand(pieces);
        if (pieces.length == 3) {
            int min = ParsingHelper.parseFilteredInteger(pieces[1], 16, "1st " + this.key.key);
            int max = ParsingHelper.parseFilteredInteger(pieces[2], -1, "2nd " + this.key.key);
            TypeValuePair typeValue = new TypeValuePair(this.key, new Object[]{this.isInverted(pieces[0]), min, max});
            parsedChainable.add(typeValue);
            operandvalue.add(operand);
            return true;
        }
        ProjectZuluLog.severe("Error Parsing %s Parameter. Invalid Argument Length.", this.key.key);
        return false;
    }

    @Override
    public boolean parseValue(String parseable, HashMap<String, Object> valueCache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValidLocation(World world, EntityLiving entity, int xCoord, int yCoord, int zCoord, TypeValuePair typeValuePair, HashMap<String, Object> valueCache) {
        boolean isValid;
        Object[] values = (Object[])typeValuePair.getValue();
        boolean isInverted = (Boolean)values[0];
        int current = this.getCurrent(world, entity, xCoord, yCoord, zCoord, typeValuePair, valueCache);
        int minRange = (Integer)values[1];
        int maxRange = (Integer)values[2];
        boolean bl = isValid = current > maxRange || current < minRange;
        if (minRange <= maxRange) {
            isValid = current <= maxRange && current >= minRange;
        } else {
            boolean bl2 = isValid = current >= minRange || current <= maxRange;
        }
        return isInverted ? isValid : !isValid;
    }

    abstract int getCurrent(World var1, EntityLiving var2, int var3, int var4, int var5, TypeValuePair var6, HashMap<String, Object> var7);
}

