/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.mobs.entity;

import com.stek101.projectzulu.common.mobs.entity.EntityFollower;
import com.stek101.projectzulu.common.mobs.entity.EntityGenericAnimal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class EntityMaster
extends EntityGenericAnimal {
    List<EntityFollower> followerList = new ArrayList<EntityFollower>();
    int numberOfFollowers = 5;
    boolean spawnFollowers = true;
    int distanceIncrements = 5;
    float distancePerIncrement;
    boolean isPositionListSetup = false;
    LinkedList<Vec3> positionList = new LinkedList();

    public EntityMaster(World par1World) {
        super(par1World);
        this.distancePerIncrement = this.field_70130_N / 2.0f / (float)this.distanceIncrements;
        while (this.followerList.size() < this.numberOfFollowers) {
            this.followerList.add(null);
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.isPositionListSetup) {
            double xzOffset = 0.0;
            while (this.positionList.size() < this.numberOfFollowers * this.distanceIncrements + 1) {
                this.positionList.add(Vec3.func_72443_a((double)(this.field_70165_t + xzOffset), (double)this.field_70163_u, (double)this.field_70161_v));
                xzOffset += (double)this.distancePerIncrement;
            }
            this.isPositionListSetup = true;
        }
        double minDistanceToIterateList = this.distancePerIncrement;
        while (this.calcDistance(this.field_70165_t, this.field_70161_v, this.positionList.getFirst().field_72450_a, this.positionList.getFirst().field_72449_c) > minDistanceToIterateList) {
            double xDist = this.field_70165_t - this.positionList.getFirst().field_72450_a;
            double zDist = this.field_70161_v - this.positionList.getFirst().field_72449_c;
            double scaleFactor = minDistanceToIterateList / this.calcDistance(this.field_70165_t, this.field_70161_v, this.positionList.getFirst().field_72450_a, this.positionList.getFirst().field_72449_c);
            double actualXCoord = this.positionList.getFirst().field_72450_a + xDist * scaleFactor;
            double actualZCoord = this.positionList.getFirst().field_72449_c + zDist * scaleFactor;
            this.positionList.addFirst(Vec3.func_72443_a((double)actualXCoord, (double)this.field_70163_u, (double)actualZCoord));
            this.positionList.removeLast();
        }
        double prevX = this.field_70165_t;
        double prevZ = this.field_70161_v;
        for (int i = 0; i < this.followerList.size(); ++i) {
            if (this.followerList.get(i) == null) continue;
            EntityFollower entityFollower = this.followerList.get(i);
            double setXAround = this.positionList.get((int)((i + 1) * this.distanceIncrements)).field_72450_a;
            double setZAround = this.positionList.get((int)((i + 1) * this.distanceIncrements)).field_72449_c;
            double setYAround = this.positionList.get((int)((i + 1) * this.distanceIncrements)).field_72448_b;
            entityFollower.setTargetPosition(Vec3.func_72443_a((double)setXAround, (double)this.field_70163_u, (double)setZAround));
            entityFollower.setTargetRotation((float)(Math.atan2(setXAround - prevX, prevZ - setZAround) * 57.29577951308232));
            prevX = setXAround;
            prevZ = setZAround;
            if (i <= 0 || this.followerList.get(i - 1) == null || !this.followerList.get((int)(i - 1)).field_70128_L) continue;
            entityFollower.shouldBeDying = true;
        }
    }

    public void func_70629_bd() {
        int currentNumOfFollowers = 0;
        for (int i = 0; i < this.followerList.size(); ++i) {
            if (this.followerList.get(i) == null || this.followerList.get((int)i).field_70128_L && this.spawnFollowers) {
                this.followerList.set(i, new EntityFollower(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this, i));
                this.field_70170_p.func_72838_d((Entity)this.followerList.get(i));
            }
            EntityFollower entityFollower = this.followerList.get(i);
            if (entityFollower.field_70128_L) continue;
            ++currentNumOfFollowers;
        }
        this.spawnFollowers = currentNumOfFollowers < this.numberOfFollowers;
        super.func_70629_bd();
    }

    public boolean linkFollowerWithMaster(EntityFollower entityFollower, int followerIndex) {
        if (this.followerList.get(followerIndex) != null && !this.followerList.get((int)followerIndex).field_70128_L) {
            return false;
        }
        this.followerList.set(followerIndex, entityFollower);
        return true;
    }

    public boolean attackEntityFromChild(EntityFollower var1, DamageSource var2, float var3) {
        if (super.func_70097_a(var2, var3)) {
            for (int i = 0; i < this.followerList.size(); ++i) {
                EntityFollower entityFollower = this.followerList.get(i);
                if (entityFollower == null) continue;
                entityFollower.hurtChildFromMaster(var2, var3);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean func_70692_ba() {
        return true;
    }

    private double calcDistance(double x1, double z1, double x2, double z2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (z2 - z1) * (z2 - z1));
    }
}

