/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.mobs.entity;

import com.stek101.projectzulu.common.api.ItemList;
import com.stek101.projectzulu.common.core.DefaultProps;
import com.stek101.projectzulu.common.mobs.entity.EntityGenericAnimal;
import com.stek101.projectzulu.common.mobs.entity.EntityMummy;
import com.stek101.projectzulu.common.mobs.entity.EntityStates;
import com.stek101.projectzulu.common.mobs.entityai.EntityAIAttackOnCollide;
import com.stek101.projectzulu.common.mobs.entityai.EntityAIHurtByTarget;
import com.stek101.projectzulu.common.mobs.entityai.EntityAINearestAttackableTarget;
import com.stek101.projectzulu.common.mobs.entityai.EntityAIWander;
import cpw.mods.fml.common.Loader;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityMummyPharaoh
extends EntityGenericAnimal
implements IMob {
    Vec3 startingPosition;
    int stage = 1;
    int maxMummySpawned = 6;
    int mummySpawned = 0;
    boolean spawnMummy = false;
    int spawnCooldown = 80;
    int spawnTimer = 60;
    boolean shootFireball = false;
    int shootCooldown = 120;
    int shootTimer = 30;
    private static final ItemStack defaultHeldItem = ItemList.ankh.isPresent() ? new ItemStack((Item)ItemList.ankh.get()) : new ItemStack(Items.field_151040_l);

    public EntityMummyPharaoh(World par1World) {
        super(par1World);
        this.func_70105_a(0.8f, 2.6f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide(this, 1.0f, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander(this, 1.0f, 120));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget(this, false, false));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget(this, EnumSet.allOf(EntityStates.class), EntityPlayer.class, 16.0f, 0, true));
    }

    public EntityMummyPharaoh(World par1World, double parx, double pary, double parz) {
        this(par1World);
        this.func_70012_b(parx, pary, parz, 1.0f, 1.0f);
        this.func_70107_b(parx, pary, parz);
        this.field_70129_M = 0.0f;
    }

    public ItemStack func_70694_bm() {
        return defaultHeldItem;
    }

    public int func_70658_aO() {
        switch (this.stage) {
            case 1: {
                return 4;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 10;
            }
        }
        return 2;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.startingPosition == null) {
            this.startingPosition = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        }
        switch (this.stage) {
            case 1: {
                if (!((double)this.func_110143_aJ() < 0.9 * (double)this.func_110138_aP())) break;
                this.teleportTo(this.startingPosition.field_72450_a, this.startingPosition.field_72448_b + 2.0, this.startingPosition.field_72449_c);
                ++this.stage;
                break;
            }
            case 2: {
                if (this.shootFireball && !this.field_70170_p.field_72995_K) {
                    this.shootFireballAtTarget();
                    this.shootFireball = false;
                }
                if (!((double)this.func_110143_aJ() < 0.7 * (double)this.func_110138_aP())) break;
                this.teleportTo(this.startingPosition.field_72450_a, this.startingPosition.field_72448_b + 2.0, this.startingPosition.field_72449_c);
                ++this.stage;
                break;
            }
            case 3: {
                if (this.spawnMummy && !this.field_70170_p.field_72995_K && this.mummySpawned <= this.maxMummySpawned) {
                    this.spawnMummy();
                    this.spawnMummy = false;
                }
                if (!((double)this.func_110143_aJ() < 0.45 * (double)this.func_110138_aP())) break;
                this.teleportTo(this.startingPosition.field_72450_a, this.startingPosition.field_72448_b + 2.0, this.startingPosition.field_72449_c);
                ++this.stage;
                break;
            }
            case 4: {
                if (this.spawnMummy && !this.field_70170_p.field_72995_K && this.mummySpawned <= this.maxMummySpawned) {
                    this.spawnMummy();
                    this.spawnMummy = false;
                }
                if (!this.shootFireball || this.field_70170_p.field_72995_K) break;
                this.shootFireballAtTarget();
                this.shootFireball = false;
                break;
            }
        }
        if (this.spawnTimer == 0) {
            this.spawnMummy = true;
            this.spawnTimer = this.spawnCooldown;
        }
        this.spawnTimer = Math.max(this.spawnTimer - 1, 0);
        if (this.shootTimer == 0) {
            this.shootFireball = true;
            this.shootTimer = this.shootCooldown;
        }
        this.shootTimer = Math.max(this.shootTimer - 1, 0);
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer tempPlayer = (EntityPlayer)par1DamageSource.func_76346_g();
            double distance = tempPlayer.func_70068_e((Entity)this);
            if (distance > 10.0) {
                int holdRand = this.field_70146_Z.nextInt(2);
                if (holdRand == 1) {
                    this.teleportTo(tempPlayer.field_70165_t + 1.0, this.field_70170_p.func_72976_f((int)tempPlayer.field_70165_t + 1, (int)tempPlayer.field_70161_v + 1), tempPlayer.field_70161_v + 1.0);
                }
            } else {
                int holdRand = this.field_70146_Z.nextInt(5);
                if (holdRand == 4) {
                    this.teleportRandomly();
                }
            }
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    private void spawnMummy() {
        int Min_Distance = 5;
        int Max_Distance = 9;
        int hold = this.field_70146_Z.nextInt(2);
        int hold2 = this.field_70146_Z.nextInt(Max_Distance - Min_Distance) + Min_Distance;
        double desX = hold != 0 ? Math.floor(this.field_70165_t) + (double)hold2 : Math.floor(this.field_70165_t) - (double)hold2;
        hold = this.field_70146_Z.nextInt(2);
        hold2 = this.field_70146_Z.nextInt(Max_Distance - Min_Distance) + Min_Distance;
        double desZ = hold != 0 ? Math.floor(this.field_70161_v) + (double)hold2 : Math.floor(this.field_70161_v) - (double)hold2;
        int desY = this.field_70170_p.func_72976_f((int)desX, (int)desZ);
        if (this.field_70170_p.func_147437_c((int)desX, desY - 2, (int)desZ)) {
            this.field_70170_p.func_147449_b((int)desX, desY - 0, (int)desZ, Blocks.field_150350_a);
            this.field_70170_p.func_147449_b((int)desX, desY - 1, (int)desZ, Blocks.field_150350_a);
        }
        EntityMummy var17 = new EntityMummy(this.field_70170_p, desX += 0.5, --desY, desZ += 0.5);
        this.field_70170_p.func_72838_d((Entity)var17);
        ++this.mummySpawned;
    }

    private void shootFireballAtTarget() {
        EntityPlayer targetedEntity = this.field_70170_p.func_72856_b((Entity)this, 32.0);
        if (targetedEntity != null) {
            int holdRand = this.field_70146_Z.nextInt(10) - 5;
            double sourcePositionX = this.field_70165_t + (double)holdRand;
            double sourcePositionY = this.field_70163_u + 20.0;
            holdRand = this.field_70146_Z.nextInt(10) - 5;
            double sourcePositionZ = this.field_70161_v + (double)holdRand;
            double var11 = targetedEntity.field_70165_t - sourcePositionX;
            double var13 = targetedEntity.field_70121_D.field_72338_b + (double)(targetedEntity.field_70131_O / 2.0f) - (sourcePositionY + (double)(this.field_70131_O / 2.0f));
            double var15 = targetedEntity.field_70161_v - sourcePositionZ;
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(var11, var15)) * 180.0f / (float)Math.PI;
            this.field_70170_p.func_72889_a((EntityPlayer)null, 1008, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
            EntityLargeFireball var17 = new EntityLargeFireball(this.field_70170_p, (EntityLivingBase)this, var11, var13, var15);
            double var18 = 1.0;
            Vec3 var20 = this.func_70676_i(1.0f);
            var17.field_70165_t = sourcePositionX + var20.field_72450_a * var18;
            var17.field_70163_u = sourcePositionY + (double)(this.field_70131_O / 2.0f) + 0.5;
            var17.field_70161_v = sourcePositionZ + var20.field_72449_c * var18;
            this.field_70170_p.func_72838_d((Entity)var17);
        }
    }

    private void shootFireballAroundTarget() {
        EntityPlayer targetedEntity = this.field_70170_p.func_72856_b((Entity)this, 32.0);
        if (targetedEntity != null) {
            int holdRand = this.field_70146_Z.nextInt(10) - 5;
            double sourcePositionX = this.field_70165_t + (double)holdRand;
            double sourcePositionY = this.field_70163_u + 20.0;
            holdRand = this.field_70146_Z.nextInt(10) - 5;
            double sourcePositionZ = this.field_70161_v + (double)holdRand;
            double desX = targetedEntity.field_70165_t + (double)this.field_70146_Z.nextInt(10) - 5.0;
            double desZ = targetedEntity.field_70161_v + (double)this.field_70146_Z.nextInt(10) - 5.0;
            int desY = this.field_70170_p.func_72976_f((int)desX, (int)desZ);
            double var11 = desX - sourcePositionX;
            double var13 = targetedEntity.field_70121_D.field_72338_b + (double)(targetedEntity.field_70131_O / 2.0f) - (sourcePositionY + (double)(this.field_70131_O / 2.0f));
            double var15 = desZ - sourcePositionZ;
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(var11, var15)) * 180.0f / (float)Math.PI;
            this.field_70170_p.func_72889_a((EntityPlayer)null, 1008, (int)desX, desY, (int)desZ, 0);
            EntityLargeFireball var17 = new EntityLargeFireball(this.field_70170_p, (EntityLivingBase)this, var11, var13, var15);
            double var18 = 4.0;
            Vec3 var20 = this.func_70676_i(1.0f);
            var17.field_70165_t = sourcePositionX + var20.field_72450_a * var18;
            var17.field_70163_u = sourcePositionY + (double)(this.field_70131_O / 2.0f) + 0.5;
            var17.field_70161_v = sourcePositionZ + var20.field_72449_c * var18;
            this.field_70170_p.func_72838_d((Entity)var17);
        }
    }

    private boolean teleportRandomly() {
        double var1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 24.0;
        double var5 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 24.0;
        double var3 = this.field_70170_p.func_72976_f((int)var1, (int)var5);
        return this.teleportTo(var1, var3, var5);
    }

    private boolean teleportTo(double par1, double par3, double par5) {
        int var16;
        int var15;
        double var7 = this.field_70165_t;
        double var9 = this.field_70163_u;
        double var11 = this.field_70161_v;
        this.field_70165_t = par1;
        this.field_70163_u = par3;
        this.field_70161_v = par5;
        boolean var13 = false;
        int var14 = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72899_e(var14, var15 = MathHelper.func_76128_c((double)this.field_70163_u), var16 = MathHelper.func_76128_c((double)this.field_70161_v))) {
            boolean var17 = false;
            while (!var17 && var15 > 0) {
                Block var18 = this.field_70170_p.func_147439_a(var14, var15 - 1, var16);
                if (var18 != null && var18.func_149688_o().func_76230_c()) {
                    var17 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                --var15;
            }
            if (var17) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D)) {
                    var13 = true;
                }
            }
        }
        if (!var13) {
            this.func_70107_b(var7, var9, var11);
            return false;
        }
        int var30 = 128;
        for (int var18 = 0; var18 < var30; ++var18) {
            double var19 = (double)var18 / ((double)var30 - 1.0);
            float var21 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float var22 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float var23 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double var24 = var7 + (this.field_70165_t - var7) * var19 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double var26 = var9 + (this.field_70163_u - var9) * var19 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double var28 = var11 + (this.field_70161_v - var11) * var19 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_72869_a("portal", var24, var26, var28, (double)var21, (double)var22, (double)var23);
        }
        this.field_70170_p.func_72908_a(var7, var9, var11, "mob.endermen.portal", 1.0f, 1.0f);
        this.field_70170_p.func_72956_a((Entity)this, "mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    protected void func_145780_a(int xCoord, int yCoord, int zCoord, Block stepBlock) {
        this.field_70170_p.func_72956_a((Entity)this, "mob.irongolem.walk", 1.0f, 1.0f);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    protected void func_70600_l(int par1) {
        if (Loader.isModLoaded((String)"ProjectZulu|Block") && ItemList.ankh.isPresent()) {
            ItemStack var2 = new ItemStack((Item)ItemList.ankh.get());
            this.func_70099_a(var2, 5.0f);
        }
    }

    protected String func_70639_aQ() {
        return "projectzulumob:" + DefaultProps.entitySounds + "mummymoan";
    }

    protected String func_70621_aR() {
        return "projectzulumob:" + DefaultProps.entitySounds + "mummyroar";
    }

    public int func_70627_aG() {
        return 160;
    }
}

