/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.mobs.entitydefaults;

import com.stek101.projectzulu.common.api.CustomMobData;
import com.stek101.projectzulu.common.core.entitydeclaration.EntityProperties;
import com.stek101.projectzulu.common.core.entitydeclaration.SpawnableDeclaration;
import com.stek101.projectzulu.common.mobs.entity.EntityBeetleAS;
import com.stek101.projectzulu.common.mobs.models.ModelBeetleAS;
import com.stek101.projectzulu.common.mobs.renders.RenderGenericLivingMT;
import com.stek101.projectzulu.common.mobs.renders.RenderWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

public class BeetleASDeclaration
extends SpawnableDeclaration {
    private final List<String> entityTextures = new ArrayList<String>();

    public BeetleASDeclaration() {
        super("BeetleAS", 62, EntityBeetleAS.class, EnumCreatureType.ambient);
        this.setSpawnProperties(10, 5, 1, 1);
        this.setRegistrationProperties(128, 3, true);
        this.setDropAmount(0, 1);
        this.eggColor1 = 14843392;
        this.eggColor2 = 4223375;
        this.entityTextures.add("textures/beetleas1.png");
        this.entityTextures.add("textures/beetleas2.png");
        this.entityTextures.add("textures/beetleas3.png");
        this.entityTextures.add("textures/beetleas4.png");
        this.entityTextures.add("textures/beetleas5.png");
    }

    @Override
    public void outputDataToList(Configuration config, CustomMobData customMobData) {
        customMobData.entityProperties = new EntityProperties(1.0f, 0.0f, 0.15f).createFromConfig(config, this.mobName);
        super.outputDataToList(config, customMobData);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderWrapper getEntityrender(Class<? extends EntityLivingBase> entityClass) {
        return new RenderGenericLivingMT((ModelBase)new ModelBeetleAS(), 0.5f, this.entityTextures);
    }

    @Override
    public HashSet<String> getDefaultBiomesToSpawn() {
        HashSet<String> defaultBiomesToSpawn = new HashSet<String>();
        defaultBiomesToSpawn.add(BiomeGenBase.field_76767_f.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_76785_t.field_76791_y);
        defaultBiomesToSpawn.add("Autumn Woods");
        defaultBiomesToSpawn.add("Birch Forest");
        defaultBiomesToSpawn.add("Forested Hills");
        defaultBiomesToSpawn.add("Forested Island");
        defaultBiomesToSpawn.add("Green Hills");
        defaultBiomesToSpawn.add("Redwood Forest");
        defaultBiomesToSpawn.add("Lush Redwoods");
        defaultBiomesToSpawn.add("Temperate Rainforest");
        defaultBiomesToSpawn.add("Woodlands");
        HashSet<String> nonFrozenForest = new HashSet<String>();
        nonFrozenForest.addAll(this.typeToArray(BiomeDictionary.Type.FOREST));
        nonFrozenForest.addAll(this.typeToArray(BiomeDictionary.Type.PLAINS));
        nonFrozenForest.removeAll(this.typeToArray(BiomeDictionary.Type.FROZEN));
        defaultBiomesToSpawn.addAll(nonFrozenForest);
        return defaultBiomesToSpawn;
    }
}

