/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.mobs.entitydefaults;

import com.stek101.projectzulu.common.api.CustomMobData;
import com.stek101.projectzulu.common.core.entitydeclaration.EntityProperties;
import com.stek101.projectzulu.common.core.entitydeclaration.SpawnableDeclaration;
import com.stek101.projectzulu.common.mobs.entity.EntityBloomDoom;
import com.stek101.projectzulu.common.mobs.models.ModelBloomDoom;
import com.stek101.projectzulu.common.mobs.renders.RenderGenericIdle;
import com.stek101.projectzulu.common.mobs.renders.RenderWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

public class BloomDoomDeclaration
extends SpawnableDeclaration {
    public BloomDoomDeclaration() {
        super("BloomDoom", 64, EntityBloomDoom.class, EnumCreatureType.creature);
        this.setSpawnProperties(10, 5, 1, 1);
        this.setRegistrationProperties(128, 3, true);
        this.setDropAmount(0, 1);
        this.eggColor1 = 8775936;
        this.eggColor2 = 6670479;
    }

    @Override
    public void outputDataToList(Configuration config, CustomMobData customMobData) {
        customMobData.entityProperties = new EntityProperties(15.0f, 2.0f, 0.25f).createFromConfig(config, this.mobName);
        super.outputDataToList(config, customMobData);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderWrapper getEntityrender(Class<? extends EntityLivingBase> entityClass) {
        return new RenderGenericIdle(new ModelBloomDoom(), 0.5f, new ResourceLocation("projectzulumob", "textures/bloomdoom0.png"), new ResourceLocation("projectzulumob", "textures/bloomdoomidle0.png"));
    }

    @Override
    public HashSet<String> getDefaultBiomesToSpawn() {
        HashSet<String> defaultBiomesToSpawn = new HashSet<String>();
        defaultBiomesToSpawn.add(BiomeGenBase.field_76767_f.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_76785_t.field_76791_y);
        defaultBiomesToSpawn.add("Autumn Woods");
        defaultBiomesToSpawn.add("Birch Forest");
        defaultBiomesToSpawn.add("Forested Hills");
        defaultBiomesToSpawn.add("Forested Island");
        defaultBiomesToSpawn.add("Green Hills");
        defaultBiomesToSpawn.add("Redwood Forest");
        defaultBiomesToSpawn.add("Lush Redwoods");
        defaultBiomesToSpawn.add("Temperate Rainforest");
        defaultBiomesToSpawn.add("Woodlands");
        HashSet<String> nonFrozenForest = new HashSet<String>();
        nonFrozenForest.addAll(this.typeToArray(BiomeDictionary.Type.FOREST));
        nonFrozenForest.addAll(this.typeToArray(BiomeDictionary.Type.PLAINS));
        nonFrozenForest.removeAll(this.typeToArray(BiomeDictionary.Type.FROZEN));
        defaultBiomesToSpawn.addAll(nonFrozenForest);
        return defaultBiomesToSpawn;
    }
}

