/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.mobs.entitydefaults;

import com.stek101.projectzulu.common.api.CustomMobData;
import com.stek101.projectzulu.common.api.ItemList;
import com.stek101.projectzulu.common.core.ConfigHelper;
import com.stek101.projectzulu.common.core.ItemGenerics;
import com.stek101.projectzulu.common.core.entitydeclaration.EntityProperties;
import com.stek101.projectzulu.common.core.entitydeclaration.SpawnableDeclaration;
import com.stek101.projectzulu.common.mobs.entity.EntityDuck;
import com.stek101.projectzulu.common.mobs.models.ModelDuck;
import com.stek101.projectzulu.common.mobs.renders.RenderGenericLiving;
import com.stek101.projectzulu.common.mobs.renders.RenderWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

public class DuckDeclaration
extends SpawnableDeclaration {
    public DuckDeclaration() {
        super("Duck", 47, EntityDuck.class, EnumCreatureType.creature);
        this.setSpawnProperties(10, 100, 1, 4);
        this.setRegistrationProperties(128, 3, true);
        this.setDropAmount(0, 2);
        this.eggColor1 = 13158426;
        this.eggColor2 = 8882155;
    }

    @Override
    public void outputDataToList(Configuration config, CustomMobData customMobData) {
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, Items.field_151008_G, 0, 8);
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.scrapMeat, 0, 10);
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.genericCraftingItems, ItemGenerics.Properties.SmallHeart.meta(), 4);
        customMobData.entityProperties = new EntityProperties(5.0f, 1.0f, 0.35f, 0.0f, 0.0f, 32.0f, 10.0f, 16.0).createFromConfig(config, this.mobName);
        super.outputDataToList(config, customMobData);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderWrapper getEntityrender(Class<? extends EntityLivingBase> entityClass) {
        return new RenderGenericLiving(new ModelDuck(), 0.5f, new ResourceLocation("projectzulumob", "textures/duck.png"));
    }

    @Override
    public HashSet<String> getDefaultBiomesToSpawn() {
        HashSet<String> defaultBiomesToSpawn = new HashSet<String>();
        defaultBiomesToSpawn.add(BiomeGenBase.field_76781_i.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_76780_h.field_76791_y);
        HashSet<String> nonFrozenForest = new HashSet<String>();
        nonFrozenForest.addAll(this.typeToArray(BiomeDictionary.Type.RIVER));
        nonFrozenForest.addAll(this.typeToArray(BiomeDictionary.Type.WET));
        nonFrozenForest.removeAll(this.typeToArray(BiomeDictionary.Type.FROZEN));
        defaultBiomesToSpawn.addAll(nonFrozenForest);
        return defaultBiomesToSpawn;
    }
}

