/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.mobs.entitydefaults;

import com.stek101.projectzulu.common.api.CustomMobData;
import com.stek101.projectzulu.common.api.ItemList;
import com.stek101.projectzulu.common.core.ConfigHelper;
import com.stek101.projectzulu.common.core.ItemGenerics;
import com.stek101.projectzulu.common.core.entitydeclaration.EntityProperties;
import com.stek101.projectzulu.common.core.entitydeclaration.SpawnableDeclaration;
import com.stek101.projectzulu.common.mobs.entity.EntityGiantRat;
import com.stek101.projectzulu.common.mobs.models.ModelGiantRat;
import com.stek101.projectzulu.common.mobs.renders.RenderGenericLiving;
import com.stek101.projectzulu.common.mobs.renders.RenderWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

public class GiantRatDeclaration
extends SpawnableDeclaration {
    public GiantRatDeclaration() {
        super("GiantRat", 55, EntityGiantRat.class, EnumCreatureType.creature);
        this.setSpawnProperties(8, 100, 1, 3);
        this.setRegistrationProperties(128, 3, true);
        this.setDropAmount(0, 2);
        this.eggColor1 = 0x664455;
        this.eggColor2 = 0x99AAAA;
    }

    @Override
    public void outputDataToList(Configuration config, CustomMobData customMobData) {
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.furPelt, 0, 10);
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.scrapMeat, 0, 10);
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.genericCraftingItems, ItemGenerics.Properties.SmallHeart.meta(), 5);
        customMobData.entityProperties = new EntityProperties(15.0f, 3.0f, 0.3f, 0.0f, 0.0f, 32.0f, 50.0f, 16.0).createFromConfig(config, this.mobName);
        super.outputDataToList(config, customMobData);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderWrapper getEntityrender(Class<? extends EntityLivingBase> entityClass) {
        return new RenderGenericLiving(new ModelGiantRat(), 0.5f, new ResourceLocation("projectzulumob", "textures/giantrat0.png"));
    }

    @Override
    public HashSet<String> getDefaultBiomesToSpawn() {
        HashSet<String> defaultBiomesToSpawn = new HashSet<String>();
        defaultBiomesToSpawn.add(BiomeGenBase.field_76772_c.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_76770_e.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_76767_f.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_76768_g.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_76780_h.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_76785_t.field_76791_y);
        HashSet<String> nonFrozen = new HashSet<String>();
        nonFrozen.addAll(this.typeToArray(BiomeDictionary.Type.MOUNTAIN));
        nonFrozen.addAll(this.typeToArray(BiomeDictionary.Type.FOREST));
        nonFrozen.addAll(this.typeToArray(BiomeDictionary.Type.PLAINS));
        nonFrozen.removeAll(this.typeToArray(BiomeDictionary.Type.FROZEN));
        defaultBiomesToSpawn.addAll(nonFrozen);
        return defaultBiomesToSpawn;
    }
}

