/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.mobs.entitydefaults;

import com.google.common.base.Optional;
import com.stek101.projectzulu.common.api.CustomEntityList;
import com.stek101.projectzulu.common.api.CustomMobData;
import com.stek101.projectzulu.common.api.ItemList;
import com.stek101.projectzulu.common.core.ConfigHelper;
import com.stek101.projectzulu.common.core.ItemGenerics;
import com.stek101.projectzulu.common.core.entitydeclaration.EntityProperties;
import com.stek101.projectzulu.common.core.entitydeclaration.SpawnableDeclaration;
import com.stek101.projectzulu.common.mobs.entity.EntityHorseBlack;
import com.stek101.projectzulu.common.mobs.models.ModelHorse;
import com.stek101.projectzulu.common.mobs.renders.RenderGenericHorseMT;
import com.stek101.projectzulu.common.mobs.renders.RenderWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Items;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

public class HorseBlackDeclaration
extends SpawnableDeclaration {
    private final List<String> wildTextures = new ArrayList<String>();
    private final List<String> saddledTextures = new ArrayList<String>();

    public HorseBlackDeclaration() {
        super("Horse", 29, EntityHorseBlack.class, EnumCreatureType.creature);
        this.setSpawnProperties(5, 50, 1, 2);
        this.setRegistrationProperties(128, 3, true);
        this.setDropAmount(0, 3);
        this.eggColor1 = 0x111111;
        this.eggColor2 = 0xBABABA;
        this.wildTextures.add("textures/horse/horse_black.png");
        this.wildTextures.add("textures/horse/horse_grey.png");
        this.wildTextures.add("textures/horse/horse_white.png");
        this.wildTextures.add("textures/horse/horse_brown.png");
        this.wildTextures.add("textures/horse/horse_beige.png");
        this.wildTextures.add("textures/horse/horse_dark_black.png");
        this.wildTextures.add("textures/horse/horse_dark_brown.png");
        this.saddledTextures.add("textures/horse/horse_black_saddled.png");
        this.saddledTextures.add("textures/horse/horse_grey_saddled.png");
        this.saddledTextures.add("textures/horse/horse_white_saddled.png");
        this.saddledTextures.add("textures/horse/horse_brown_saddled.png");
        this.saddledTextures.add("textures/horse/horse_beige_saddled.png");
        this.saddledTextures.add("textures/horse/horse_dark_black_saddled.png");
        this.saddledTextures.add("textures/horse/horse_dark_brown_saddled.png");
    }

    @Override
    public void outputDataToList(Configuration config, CustomMobData customMobData) {
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, Items.field_151082_bd, 0, 10);
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.scrapMeat, 0, 10);
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.genericCraftingItems, ItemGenerics.Properties.LargeHeart.meta(), 4);
        ConfigHelper.userItemConfigRangeToMobData(config, "MOB CONTROLS." + this.mobName, customMobData);
        customMobData.entityProperties = new EntityProperties(20.0f, 3.0f, 0.3f, 0.0f, 0.5f, 32.0f, 10.0f, 16.0).createFromConfig(config, this.mobName);
        CustomEntityList.HORSE.modData = Optional.of((Object)customMobData);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderWrapper getEntityrender(Class<? extends EntityLivingBase> entityClass) {
        return new RenderGenericHorseMT(new ModelHorse(), 0.5f, this.wildTextures, this.saddledTextures);
    }

    @Override
    public HashSet<String> getDefaultBiomesToSpawn() {
        HashSet<String> defaultBiomesToSpawn = new HashSet<String>();
        defaultBiomesToSpawn.add(BiomeGenBase.field_76772_c.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_76767_f.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_150588_X.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_76785_t.field_76791_y);
        HashSet<String> nonFrozenForest = new HashSet<String>();
        nonFrozenForest.addAll(this.typeToArray(BiomeDictionary.Type.FOREST));
        nonFrozenForest.addAll(this.typeToArray(BiomeDictionary.Type.PLAINS));
        defaultBiomesToSpawn.addAll(nonFrozenForest);
        return defaultBiomesToSpawn;
    }
}

