/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.mobs.entitydefaults;

import com.stek101.projectzulu.common.api.CustomMobData;
import com.stek101.projectzulu.common.api.ItemList;
import com.stek101.projectzulu.common.core.ConfigHelper;
import com.stek101.projectzulu.common.core.ItemGenerics;
import com.stek101.projectzulu.common.core.entitydeclaration.EntityProperties;
import com.stek101.projectzulu.common.core.entitydeclaration.SpawnableDeclaration;
import com.stek101.projectzulu.common.mobs.entity.EntityRabbit;
import com.stek101.projectzulu.common.mobs.models.ModelRabbit;
import com.stek101.projectzulu.common.mobs.renders.RenderGenericLivingMT;
import com.stek101.projectzulu.common.mobs.renders.RenderWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

public class RabbitDeclaration
extends SpawnableDeclaration {
    private final List<String> entityTextures = new ArrayList<String>();

    public RabbitDeclaration() {
        super("Rabbit", 21, EntityRabbit.class, EnumCreatureType.creature);
        this.setSpawnProperties(15, 100, 2, 4);
        this.setRegistrationProperties(128, 3, true);
        this.setDropAmount(0, 1);
        this.eggColor1 = 15709011;
        this.eggColor2 = 15585446;
        this.entityTextures.add("textures/rabbit0.png");
        this.entityTextures.add("textures/rabbit1.png");
        this.entityTextures.add("textures/rabbit2.png");
        this.entityTextures.add("textures/rabbit3.png");
        this.entityTextures.add("textures/rabbit4.png");
        this.entityTextures.add("textures/rabbit5.png");
        this.entityTextures.add("textures/rabbit6.png");
        this.entityTextures.add("textures/rabbit7.png");
        this.entityTextures.add("textures/rabbit8.png");
    }

    @Override
    public void outputDataToList(Configuration config, CustomMobData customMobData) {
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.scrapMeat, 0, 10);
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.genericCraftingItems, ItemGenerics.Properties.SmallHeart.meta(), 4);
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.genericCraftingItems, ItemGenerics.Properties.RabbitsFoot.meta(), 8);
        customMobData.entityProperties = new EntityProperties(5.0f, 1.0f, 0.3f, 100.0f, 0.0f, 32.0f, 1.0f, 10.0).createFromConfig(config, this.mobName);
        super.outputDataToList(config, customMobData);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderWrapper getEntityrender(Class<? extends EntityLivingBase> entityClass) {
        return new RenderGenericLivingMT((ModelBase)new ModelRabbit(), 0.5f, this.entityTextures);
    }

    @Override
    public HashSet<String> getDefaultBiomesToSpawn() {
        HashSet<String> defaultBiomesToSpawn = new HashSet<String>();
        defaultBiomesToSpawn.add(BiomeGenBase.field_76772_c.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_76767_f.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_76785_t.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_150588_X.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_150583_P.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_150582_Q.field_76791_y);
        defaultBiomesToSpawn.add("Autumn Woods");
        defaultBiomesToSpawn.add("Birch Forest");
        defaultBiomesToSpawn.add("Forested Hills");
        defaultBiomesToSpawn.add("Forested Island");
        defaultBiomesToSpawn.add("Green Hills");
        defaultBiomesToSpawn.add("Redwood Forest");
        defaultBiomesToSpawn.add("Lush Redwoods");
        defaultBiomesToSpawn.add("Temperate Rainforest");
        defaultBiomesToSpawn.add("Woodlands");
        HashSet<String> nonFrozenForest = new HashSet<String>();
        nonFrozenForest.addAll(this.typeToArray(BiomeDictionary.Type.FOREST));
        nonFrozenForest.addAll(this.typeToArray(BiomeDictionary.Type.PLAINS));
        nonFrozenForest.addAll(this.typeToArray(BiomeDictionary.Type.SAVANNA));
        nonFrozenForest.removeAll(this.typeToArray(BiomeDictionary.Type.SNOWY));
        defaultBiomesToSpawn.addAll(nonFrozenForest);
        return defaultBiomesToSpawn;
    }
}

