/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world.retroGenerator;

import com.google.common.collect.Maps;
import com.stek101.projectzulu.common.world.retroGenerator.ChunkCoord;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldSavedData;

public class RetroGenSaveData
extends WorldSavedData {
    private Map<ChunkCoord, NBTTagCompound> chunks = Maps.newHashMap();
    private final String NBT_SIZE = "size";
    private final String NBT_LOC_X = "CoordLocX";
    private final String NBT_LOC_Z = "CoordLocZ";
    private final String NBT_TAG = "tag";

    public RetroGenSaveData(String name) {
        super(name);
    }

    public boolean isGenerationNeeded(ChunkCoord coord, String genID) {
        NBTTagCompound nbt = this.chunks.get(coord);
        return nbt == null || !nbt.func_74764_b(genID) || !nbt.func_74767_n(genID);
    }

    public void markChunkRetroGenerated(ChunkCoord coord, String genID) {
        NBTTagCompound nbt = this.chunks.get(coord);
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74757_a(genID, true);
        this.chunks.put(coord, nbt);
        this.func_76185_a();
    }

    public void func_76184_a(NBTTagCompound nbt) {
        int size = nbt.func_74762_e("size");
        for (int i = 0; i < size; ++i) {
            ChunkCoord coord = new ChunkCoord(nbt.func_74762_e(i + "CoordLocX"), nbt.func_74762_e(i + "CoordLocZ"));
            this.chunks.put(coord, nbt.func_74775_l(i + "tag"));
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        nbt.func_74768_a("size", this.chunks.size());
        int index = 0;
        for (ChunkCoord coord : this.chunks.keySet()) {
            nbt.func_74768_a(index + "CoordLocX", coord.chunkX);
            nbt.func_74768_a(index + "CoordLocZ", coord.chunkZ);
            nbt.func_74782_a(index + "tag", (NBTBase)this.chunks.get(coord));
            ++index;
        }
    }
}

