/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.architect;

import com.stek101.projectzulu.common.world.dataobjects.BlockWithMeta;
import com.stek101.projectzulu.common.world2.MazeCell;
import com.stek101.projectzulu.common.world2.architect.ArchitectBase;
import com.stek101.projectzulu.common.world2.blueprint.BPSetGenericCardinal;
import com.stek101.projectzulu.common.world2.blueprint.BPSetGenericCarved;
import com.stek101.projectzulu.common.world2.blueprint.BPSetGenericEdge;
import com.stek101.projectzulu.common.world2.blueprint.BPSetGenericUncarved;
import com.stek101.projectzulu.common.world2.blueprint.BlueprintSet;
import com.stek101.projectzulu.common.world2.blueprints.BPScatteredTombstonesAndFlowers;
import com.stek101.projectzulu.common.world2.blueprints.BlueprintCemetaryEdge;
import com.stek101.projectzulu.common.world2.blueprints.BlueprintCemetaryFountain;
import com.stek101.projectzulu.common.world2.blueprints.BlueprintCemetaryFountain2;
import com.stek101.projectzulu.common.world2.blueprints.BlueprintCemeteryTomb;
import com.stek101.projectzulu.common.world2.blueprints.BlueprintCemeteryTomb2;
import java.awt.Point;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class ArchitectCemetary
extends ArchitectBase {
    BlueprintSet edge = new BPSetGenericEdge(new BlueprintCemetaryEdge());

    public ArchitectCemetary(World world) {
        super(world);
        this.stockpile.addBlueprintSet(new BPSetGenericUncarved(new BPScatteredTombstonesAndFlowers()));
        this.stockpile.addBlueprintSet(new BPSetGenericCardinal(new BlueprintCemeteryTomb(), 1));
        this.stockpile.addBlueprintSet(new BPSetGenericCardinal(new BlueprintCemeteryTomb2(), 1));
        this.stockpile.addBlueprintSet(new BPSetGenericCardinal(new BlueprintCemetaryFountain(), 1));
        this.stockpile.addBlueprintSet(new BPSetGenericCarved(new BlueprintCemetaryFountain2()));
        this.stockpile.addBlueprintSet(this.edge);
    }

    @Override
    public void assignBlueprint(MazeCell[][] cells, Point buildCoords, int pass, int maxPass) {
        BlueprintSet set = this.edge.isApplicable(cells, buildCoords, this.random) ? this.edge : this.stockpile.getRandomApplicable(cells, buildCoords);
        if (set != null) {
            set.assignCellsWithBlueprints(cells, buildCoords, this.random);
        }
    }

    @Override
    public BlockWithMeta getBlockFromBlueprint(MazeCell cell, ChunkCoordinates piecePos) {
        BlueprintSet set = this.stockpile.getBlueprintSet(cell);
        return set != null ? this.stockpile.getBlueprintSet(cell).getBlockFromBlueprint(piecePos, cell.size, cell.getHeight(), cell.getDirection(), this.random, cell.getBuildingID()) : null;
    }
}

