/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.architect;

import com.stek101.projectzulu.common.world.dataobjects.BlockWithMeta;
import com.stek101.projectzulu.common.world2.MazeCell;
import com.stek101.projectzulu.common.world2.architect.ArchitectBase;
import com.stek101.projectzulu.common.world2.blueprint.BPSetGenericCarved;
import com.stek101.projectzulu.common.world2.blueprint.BPSetGenericDeadEnd;
import com.stek101.projectzulu.common.world2.blueprint.BPSetGenericUncarved;
import com.stek101.projectzulu.common.world2.blueprint.BlueprintDeadEndChest;
import com.stek101.projectzulu.common.world2.blueprint.BlueprintLabyrinthCobweb;
import com.stek101.projectzulu.common.world2.blueprint.BlueprintLabyrinthHiddenWall;
import com.stek101.projectzulu.common.world2.blueprint.BlueprintLabyrinthRandomWall;
import com.stek101.projectzulu.common.world2.blueprint.BlueprintLabyrinthStair;
import com.stek101.projectzulu.common.world2.blueprint.BlueprintSet;
import java.awt.Point;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class ArchitectLabyrinth
extends ArchitectBase {
    BlueprintSet stair = new BPSetGenericCarved(new BlueprintLabyrinthStair());
    BlueprintSet room = new BPSetGenericUncarved(new BlueprintLabyrinthCobweb());
    BlueprintSet wall = new BPSetGenericCarved(new BlueprintLabyrinthRandomWall());

    public ArchitectLabyrinth(World world) {
        super(world);
        this.stockpile.addBlueprintSet(new BPSetGenericDeadEnd(new BlueprintDeadEndChest(), 0, 1));
        this.stockpile.addBlueprintSet(this.room);
        this.stockpile.addBlueprintSet(new BPSetGenericCarved(new BlueprintLabyrinthHiddenWall()));
        this.stockpile.addBlueprintSet(this.wall);
        this.stockpile.addBlueprintSet(this.stair);
    }

    @Override
    public void assignBlueprint(MazeCell[][] cells, Point buildCoords, int pass, int maxPass) {
        BlueprintSet set = buildCoords.x == cells.length / 2 && buildCoords.y <= 3 ? this.room : (this.isEdge(cells, buildCoords) ? this.wall : this.stockpile.getRandomApplicable(cells, buildCoords));
        if (set != null) {
            set.assignCellsWithBlueprints(cells, buildCoords, this.random);
        }
    }

    public void assignStairs(MazeCell[][] cells, Point buildCoords, int pass, int maxPass) {
        this.stair.assignCellsWithBlueprints(cells, buildCoords, this.random);
    }

    private boolean isEdge(MazeCell[][] cells, Point buildCoords) {
        return buildCoords.x == 0 || buildCoords.y == 0 || buildCoords.x == cells.length - 1 || buildCoords.y == cells[0].length - 1;
    }

    @Override
    public BlockWithMeta getBlockFromBlueprint(MazeCell cell, ChunkCoordinates piecePos) {
        BlueprintSet set = this.stockpile.getBlueprintSet(cell);
        return set != null ? this.stockpile.getBlueprintSet(cell).getBlockFromBlueprint(piecePos, cell.size, cell.getHeight(), cell.getDirection(), this.random, cell.getBuildingID()) : null;
    }
}

