/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.architect;

import com.stek101.projectzulu.common.world.dataobjects.BlockWithMeta;
import com.stek101.projectzulu.common.world2.MazeCell;
import com.stek101.projectzulu.common.world2.architect.ArchitectBase;
import com.stek101.projectzulu.common.world2.blueprint.BPSetDoorway;
import com.stek101.projectzulu.common.world2.blueprint.BPSetHallway;
import com.stek101.projectzulu.common.world2.blueprint.BPSetHallwaySpawner;
import com.stek101.projectzulu.common.world2.blueprint.BPSetPyramidEdge;
import com.stek101.projectzulu.common.world2.blueprint.BPSetStairs;
import com.stek101.projectzulu.common.world2.blueprint.BPSetTreasureDeadEnd;
import com.stek101.projectzulu.common.world2.blueprint.BPSetWall;
import com.stek101.projectzulu.common.world2.blueprint.BlueprintSet;
import java.awt.Point;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class ArchitectPyramid
extends ArchitectBase {
    public final BPSetStairs stairSet = new BPSetStairs();
    public final BPSetPyramidEdge edge = new BPSetPyramidEdge();
    public final BPSetDoorway door = new BPSetDoorway();

    public ArchitectPyramid(World world) {
        super(world);
        this.stockpile.addBlueprintSet(new BPSetWall());
        this.stockpile.addBlueprintSet(new BPSetTreasureDeadEnd());
        this.stockpile.addBlueprintSet(new BPSetHallway());
        this.stockpile.addBlueprintSet(new BPSetHallwaySpawner());
        this.stockpile.addBlueprintSet(this.stairSet);
        this.stockpile.addBlueprintSet(this.edge);
        this.stockpile.addBlueprintSet(this.door);
    }

    @Override
    public void assignBlueprint(MazeCell[][] cells, Point buildCoords, int pass, int maxPass) {
        BlueprintSet set = this.door.isApplicable(cells, buildCoords, this.random) ? this.door : (this.edge.isApplicable(cells, buildCoords, this.random) ? this.edge : this.stockpile.getRandomApplicable(cells, buildCoords));
        if (set != null) {
            set.assignCellsWithBlueprints(cells, buildCoords, this.random);
        }
    }

    public void assignStairs(MazeCell[][] bottomCells, MazeCell[][] topCells) {
        for (int topX = 0; topX < topCells.length; ++topX) {
            for (int topZ = 0; topZ < topCells[0].length; ++topZ) {
                Point buildCoords = new Point(topX, topZ);
                if (!this.stairSet.attemptAssignBlueprint(bottomCells, topCells, buildCoords, this.random)) continue;
                return;
            }
        }
    }

    @Override
    public BlockWithMeta getBlockFromBlueprint(MazeCell cell, ChunkCoordinates piecePos) {
        BlueprintSet set = this.stockpile.getBlueprintSet(cell);
        return set != null ? this.stockpile.getBlueprintSet(cell).getBlockFromBlueprint(piecePos, cell.size, cell.getHeight(), cell.getDirection(), this.random, cell.getBuildingID()) : null;
    }
}

