/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.blueprint.cathedral;

import com.stek101.projectzulu.common.world.CellIndexDirection;
import com.stek101.projectzulu.common.world.dataobjects.BlockWithMeta;
import com.stek101.projectzulu.common.world2.BoundaryPair;
import com.stek101.projectzulu.common.world2.CellHelper;
import com.stek101.projectzulu.common.world2.blueprint.Blueprint;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.WeightedRandom;

public class BPCathedralWestTower
implements Blueprint {
    @Override
    public BlockWithMeta getBlockFromBlueprint(ChunkCoordinates piecePos, int cellSize, int cellHeight, Random random, CellIndexDirection cellIndexDirection) {
        if (cellIndexDirection == CellIndexDirection.NorthWestCorner) {
            return this.getTowerBlock(CellHelper.rotateCellTo(piecePos, cellSize, CellIndexDirection.NorthWall), cellSize, cellHeight, random, cellIndexDirection);
        }
        if (cellIndexDirection == CellIndexDirection.NorthEastCorner) {
            return this.getTowerBlock(CellHelper.rotateCellTo(piecePos, cellSize, CellIndexDirection.EastWall), cellSize, cellHeight, random, cellIndexDirection);
        }
        if (cellIndexDirection == CellIndexDirection.SouthWestCorner) {
            return this.getTowerBlock(CellHelper.rotateCellTo(piecePos, cellSize, CellIndexDirection.WestWall), cellSize, cellHeight, random, cellIndexDirection);
        }
        if (cellIndexDirection == CellIndexDirection.SouthEastCorner) {
            return this.getTowerBlock(CellHelper.rotateCellTo(piecePos, cellSize, CellIndexDirection.SouthWall), cellSize, cellHeight, random, cellIndexDirection);
        }
        return null;
    }

    public BlockWithMeta getTowerBlock(ChunkCoordinates piecePos, int cellSize, int cellHeight, Random random, CellIndexDirection cellIndexDirection) {
        int slope;
        BlockWithMeta woodenPlank = new BlockWithMeta(Blocks.field_150344_f, 1);
        BlockWithMeta carvedStone = new BlockWithMeta(Blocks.field_150417_aV, 3);
        ArrayList<BlockWithMeta> wallBlocks = new ArrayList<BlockWithMeta>(3);
        wallBlocks.add(new BlockWithMeta(Blocks.field_150417_aV, 2, 8));
        wallBlocks.add(new BlockWithMeta(Blocks.field_150417_aV, 1, 8));
        wallBlocks.add(new BlockWithMeta(Blocks.field_150417_aV, 0, 100));
        int diagonalIndex = piecePos.field_71573_c + piecePos.field_71574_a;
        int stairSegmentHeight = 2;
        if (piecePos.field_71572_b > cellHeight - 6 && piecePos.field_71574_a > cellSize - 3 && piecePos.field_71573_c > cellSize - 3) {
            if (piecePos.field_71572_b == cellHeight - 2 && piecePos.field_71574_a == cellSize - 1 && piecePos.field_71573_c == cellSize - 1) {
                return carvedStone;
            }
            if (piecePos.field_71572_b < cellHeight - 2) {
                if (piecePos.field_71574_a == cellSize - 1 && piecePos.field_71573_c == cellSize - 1) {
                    return new BlockWithMeta(Blocks.field_150339_S);
                }
                if (piecePos.field_71572_b == cellHeight - 5) {
                    return carvedStone;
                }
                if (piecePos.field_71574_a == cellSize - 1 || piecePos.field_71573_c == cellSize - 1) {
                    return carvedStone;
                }
            }
        }
        if (piecePos.field_71572_b > cellHeight - cellSize * 2) {
            slope = CellHelper.getSlopeIndex(piecePos, cellSize - diagonalIndex - 1, 1.0f, BoundaryPair.createPair(1, cellSize * 2), cellHeight);
            if (slope == 0) {
                return woodenPlank;
            }
            if (slope > 0) {
                return new BlockWithMeta(Blocks.field_150350_a);
            }
        }
        if (piecePos.field_71574_a == 0 && piecePos.field_71573_c == 0) {
            return new BlockWithMeta(Blocks.field_150350_a);
        }
        if (piecePos.field_71574_a == 0 || piecePos.field_71573_c == 0) {
            if (piecePos.field_71574_a == 1 || piecePos.field_71573_c == 1) {
                return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
            }
            if (piecePos.field_71574_a == 0) {
                if (cellIndexDirection == CellIndexDirection.SouthEastCorner && piecePos.field_71572_b > 0 && piecePos.field_71572_b <= 10) {
                    if (piecePos.field_71572_b % 5 == 0 || piecePos.field_71573_c <= 1) {
                        return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
                    }
                } else {
                    if (piecePos.field_71572_b == 0 || piecePos.field_71572_b == 1) {
                        return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
                    }
                    if (piecePos.field_71573_c == 2 || piecePos.field_71573_c == 3) {
                        return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
                    }
                    if (piecePos.field_71573_c > 3 || piecePos.field_71573_c == cellSize - 2) {
                        if (piecePos.field_71573_c == cellSize - 1) {
                            return new BlockWithMeta(Blocks.field_150390_bg, this.getWindowMeta(cellIndexDirection, true, true, piecePos.field_71572_b % 4));
                        }
                        return new BlockWithMeta(Blocks.field_150390_bg, this.getWindowMeta(cellIndexDirection, true, false, piecePos.field_71572_b % 4));
                    }
                }
                return new BlockWithMeta(Blocks.field_150350_a);
            }
            if (piecePos.field_71573_c == 0) {
                if (cellIndexDirection == CellIndexDirection.NorthEastCorner && piecePos.field_71572_b > 0 && piecePos.field_71572_b <= 10) {
                    if (piecePos.field_71572_b % 5 == 0 || piecePos.field_71574_a <= 1) {
                        return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
                    }
                } else {
                    if (piecePos.field_71572_b == 0 || piecePos.field_71572_b == 1) {
                        return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
                    }
                    if (piecePos.field_71574_a == 2 || piecePos.field_71574_a == 3) {
                        return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
                    }
                    if (piecePos.field_71574_a > 3 || piecePos.field_71574_a == cellSize - 2) {
                        if (piecePos.field_71574_a == cellSize - 1) {
                            return new BlockWithMeta(Blocks.field_150390_bg, this.getWindowMeta(cellIndexDirection, false, true, piecePos.field_71572_b % 4));
                        }
                        return new BlockWithMeta(Blocks.field_150390_bg, this.getWindowMeta(cellIndexDirection, false, false, piecePos.field_71572_b % 4));
                    }
                }
                return new BlockWithMeta(Blocks.field_150350_a);
            }
        }
        if (0 < piecePos.field_71573_c && piecePos.field_71573_c < 3) {
            slope = CellHelper.getSlopeIndex(piecePos, cellSize - piecePos.field_71574_a - 1, 1.0f, BoundaryPair.createPair(0, stairSegmentHeight - 1), this.getStairSegmentTop(piecePos, cellIndexDirection));
            int slopeBelow = CellHelper.getSlopeIndex(piecePos, cellSize - piecePos.field_71574_a + 0, 1.0f, BoundaryPair.createPair(0, stairSegmentHeight - 1), this.getStairSegmentTop(piecePos, cellIndexDirection));
            if (slope == 0) {
                return slope != slopeBelow ? new BlockWithMeta(Blocks.field_150390_bg, this.getStairMeta(cellIndexDirection, true)) : (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
            }
        } else if (0 < piecePos.field_71574_a && piecePos.field_71574_a < 3) {
            slope = CellHelper.getSlopeIndex(piecePos, piecePos.field_71573_c - 2, 1.0f, BoundaryPair.createPair(1, stairSegmentHeight), this.getStairSegmentTop(piecePos, cellIndexDirection));
            int slopeBelow = CellHelper.getSlopeIndex(piecePos, piecePos.field_71573_c - 1, 1.0f, BoundaryPair.createPair(1, stairSegmentHeight), this.getStairSegmentTop(piecePos, cellIndexDirection));
            if (slope == 0) {
                return slope != slopeBelow ? new BlockWithMeta(Blocks.field_150390_bg, this.getStairMeta(cellIndexDirection, false)) : (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
            }
        }
        if (piecePos.field_71572_b % cellSize == 5 && (piecePos.field_71573_c < 1 || piecePos.field_71574_a < 1)) {
            return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
        }
        if (this.isRoomForRoom(piecePos, cellSize, cellHeight) && piecePos.field_71574_a > 2 && piecePos.field_71573_c > 2 && piecePos.field_71572_b > 0) {
            if (piecePos.field_71572_b % (stairSegmentHeight * 2) == 3) {
                return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
            }
            if (piecePos.field_71572_b != 0 && piecePos.field_71572_b - 1 != 0) {
                if (cellIndexDirection == CellIndexDirection.NorthWestCorner && piecePos.field_71573_c == 3 && piecePos.field_71574_a == 4) {
                    if (piecePos.field_71572_b % (stairSegmentHeight * 4) == 4) {
                        return new BlockWithMeta(Blocks.field_150466_ao, 1);
                    }
                    if (piecePos.field_71572_b % (stairSegmentHeight * 4) == 5) {
                        return new BlockWithMeta(Blocks.field_150466_ao, 9);
                    }
                } else if (cellIndexDirection == CellIndexDirection.SouthEastCorner && piecePos.field_71573_c == 3 && piecePos.field_71574_a == 4) {
                    if (piecePos.field_71572_b % (stairSegmentHeight * 4) == 0) {
                        return new BlockWithMeta(Blocks.field_150466_ao, 3);
                    }
                    if (piecePos.field_71572_b % (stairSegmentHeight * 4) == 1) {
                        return new BlockWithMeta(Blocks.field_150466_ao, 11);
                    }
                }
            }
            if (piecePos.field_71574_a == 3 || piecePos.field_71573_c == 3) {
                return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
            }
            if (cellIndexDirection == CellIndexDirection.SouthWestCorner && (piecePos.field_71574_a == 4 || piecePos.field_71573_c == 4) && (piecePos.field_71572_b % (stairSegmentHeight * 2) == 0 || piecePos.field_71572_b % (stairSegmentHeight * 2) == 1 && random.nextInt(3) == 0)) {
                return new BlockWithMeta(Blocks.field_150342_X);
            }
            if (cellIndexDirection == CellIndexDirection.NorthEastCorner && piecePos.field_71572_b % (stairSegmentHeight * 2) == 0 && piecePos.field_71573_c == 4 && (piecePos.field_71574_a == 4 || piecePos.field_71574_a == 5)) {
                return piecePos.field_71574_a == 5 ? new BlockWithMeta(Blocks.field_150324_C, 2) : new BlockWithMeta(Blocks.field_150324_C, 10);
            }
        }
        if (piecePos.field_71572_b == 0) {
            return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, wallBlocks);
        }
        return new BlockWithMeta(Blocks.field_150350_a);
    }

    private boolean isRoomForRoom(ChunkCoordinates piecePos, int cellSize, int cellHeight) {
        int roomHeight = 4;
        int ceilingClearance = 8;
        for (int i = 0; i < roomHeight; ++i) {
            if ((piecePos.field_71572_b + i) % roomHeight != 3) continue;
            return piecePos.field_71572_b + i + ceilingClearance <= cellHeight;
        }
        return false;
    }

    private int getStairSegmentTop(ChunkCoordinates piecePos, CellIndexDirection cellIndexDirection) {
        switch (cellIndexDirection) {
            default: {
                return (int)(4.0 + Math.floor(piecePos.field_71572_b / 8) * 8.0);
            }
            case NorthEastCorner: {
                return (int)(6.0 + Math.floor(piecePos.field_71572_b / 8) * 8.0);
            }
            case SouthEastCorner: {
                return (int)(8.0 + Math.floor((double)piecePos.field_71572_b / 8.01) * 8.0);
            }
            case SouthWestCorner: 
        }
        return (int)(2.0 + Math.floor(piecePos.field_71572_b / 8) * 8.0);
    }

    private int getStairMeta(CellIndexDirection cellIndexDirection, boolean high) {
        switch (cellIndexDirection) {
            default: {
                return high ? 0 : 3;
            }
            case NorthEastCorner: {
                return high ? 2 : 0;
            }
            case SouthEastCorner: {
                return high ? 1 : 2;
            }
            case SouthWestCorner: 
        }
        return high ? 3 : 1;
    }

    private int getWindowMeta(CellIndexDirection cellIndexDirection, boolean otherWall, boolean edge, int height) {
        if (otherWall) {
            switch (cellIndexDirection) {
                default: {
                    return this.getWindowMeta(CellIndexDirection.NorthEastCorner, edge, height);
                }
                case NorthEastCorner: {
                    return this.getWindowMeta(CellIndexDirection.SouthEastCorner, edge, height);
                }
                case SouthEastCorner: {
                    return this.getWindowMeta(CellIndexDirection.SouthWestCorner, edge, height);
                }
                case SouthWestCorner: 
            }
            return this.getWindowMeta(CellIndexDirection.NorthWestCorner, edge, height);
        }
        return this.getWindowMeta(cellIndexDirection, edge, height);
    }

    private int getWindowMeta(CellIndexDirection cellIndexDirection, boolean edge, int height) {
        switch (cellIndexDirection) {
            default: {
                if (edge) {
                    return height == 0 ? 5 : (height == 1 ? 4 : (height == 2 ? 0 : 1));
                }
                return height % 2 == 0 ? 1 : 5;
            }
            case NorthEastCorner: {
                if (edge) {
                    return height == 0 ? 7 : (height == 1 ? 6 : (height == 2 ? 2 : 3));
                }
                return height % 2 == 0 ? 3 : 7;
            }
            case SouthEastCorner: {
                if (edge) {
                    return height == 0 ? 4 : (height == 1 ? 5 : (height == 2 ? 1 : 0));
                }
                return height % 2 == 0 ? 0 : 4;
            }
            case SouthWestCorner: 
        }
        if (edge) {
            return height == 0 ? 6 : (height == 1 ? 7 : (height == 2 ? 3 : 2));
        }
        return height % 2 == 0 ? 2 : 6;
    }

    @Override
    public String getIdentifier() {
        return "CathedralWestTower";
    }

    @Override
    public int getWeight() {
        return 0;
    }
}

