/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.blueprints.oasis;

import com.stek101.projectzulu.common.world.CellIndexDirection;
import com.stek101.projectzulu.common.world.dataobjects.BlockWithMeta;
import com.stek101.projectzulu.common.world2.CellHelper;
import com.stek101.projectzulu.common.world2.blueprint.Blueprint;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.WeightedRandom;

public abstract class BPOasisEdge
implements Blueprint {
    BlockWithMeta sandstone = new BlockWithMeta(Blocks.field_150322_A);
    BlockWithMeta sand = new BlockWithMeta((Block)Blocks.field_150354_m);
    BlockWithMeta grass = new BlockWithMeta((Block)Blocks.field_150349_c);
    BlockWithMeta air = new BlockWithMeta(Blocks.field_150350_a);
    List<BlockWithMeta> flowers = new ArrayList<BlockWithMeta>();
    boolean inverted;

    public BPOasisEdge(boolean inverted) {
        this.inverted = inverted;
        this.flowers.add(new BlockWithMeta((Block)Blocks.field_150328_O, 0, 1));
        this.flowers.add(new BlockWithMeta((Block)Blocks.field_150327_N, 0, 1));
        this.flowers.add(new BlockWithMeta((Block)Blocks.field_150329_H, 1, 10));
        this.flowers.add(new BlockWithMeta(Blocks.field_150350_a, 0, 6));
    }

    @Override
    public BlockWithMeta getBlockFromBlueprint(ChunkCoordinates piecePos, int cellSize, int cellHeight, Random random, CellIndexDirection cellIndexDirection) {
        if (piecePos.field_71572_b == 0) {
            return this.sandstone;
        }
        if (piecePos.field_71572_b == 1) {
            return this.sand;
        }
        if (piecePos.field_71572_b == 2) {
            if (this.isGrass(CellHelper.rotateCellTo(piecePos, cellSize, cellIndexDirection), cellSize, cellHeight, random)) {
                return this.grass;
            }
            return this.sand;
        }
        if (piecePos.field_71572_b == 3) {
            if (this.isGrass(CellHelper.rotateCellTo(piecePos, cellSize, cellIndexDirection), cellSize, cellHeight, random)) {
                return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, this.flowers);
            }
            return this.air;
        }
        return this.air;
    }

    public abstract boolean isGrass(ChunkCoordinates var1, int var2, int var3, Random var4);

    @Override
    public final String getIdentifier() {
        return "OasisEdge".concat(Boolean.toString(this.inverted)).concat(this.childIdentifier());
    }

    public abstract String childIdentifier();
}

