/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.buildingmanager;

import com.stek101.projectzulu.common.core.terrain.TerrainFeature;
import com.stek101.projectzulu.common.world.dataobjects.BlockWithMeta;
import com.stek101.projectzulu.common.world2.MazeCell;
import com.stek101.projectzulu.common.world2.architect.ArchitectCathedral;
import com.stek101.projectzulu.common.world2.buildingmanager.BuildingManagerBase;
import com.stek101.projectzulu.common.world2.randomizer.Randomizer;
import com.stek101.projectzulu.common.world2.randomizer.WalledMazeRandomizer;
import java.awt.Point;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class BuildingManagerCathedral
extends BuildingManagerBase {
    public ArchitectCathedral architect;
    public Randomizer randomizer;
    MazeCell[][] cathedral;

    public BuildingManagerCathedral(World world, ChunkCoordinates startingPos, TerrainFeature.FeatureDirection direction) {
        super(world);
        this.architect = new ArchitectCathedral(world);
        this.randomizer = new WalledMazeRandomizer(world);
        int xCells = 7;
        int zCells = 7;
        int cellSize = 6;
        int cellHeight = 15;
        startingPos = this.calcTranslatedPosition(direction, startingPos, xCells * cellSize, zCells * cellSize, cellHeight);
        this.cathedral = new MazeCell[xCells][zCells];
        for (int i = 0; i < this.cathedral.length; ++i) {
            for (int j = 0; j < this.cathedral[0].length; ++j) {
                this.cathedral[i][j] = new MazeCell(cellSize, cellHeight, new ChunkCoordinates(startingPos.field_71574_a + cellSize * i, startingPos.field_71572_b, startingPos.field_71573_c + cellSize * j));
            }
        }
    }

    @Override
    protected void randomizeCells() {
        this.randomizer.randomize(this.cathedral);
    }

    @Override
    protected void assignBlueprints(int pass, int maxPass) {
        if (pass == maxPass) {
            for (int cellX = 0; cellX < this.cathedral.length; ++cellX) {
                for (int cellZ = 0; cellZ < this.cathedral[0].length; ++cellZ) {
                    this.architect.assignBlueprint(this.cathedral, new Point(cellX, cellZ), pass, maxPass);
                }
            }
        }
    }

    @Override
    protected void construct() {
        for (int cellX = 0; cellX < this.cathedral.length; ++cellX) {
            for (int cellZ = 0; cellZ < this.cathedral[0].length; ++cellZ) {
                MazeCell currentCell = this.cathedral[cellX][cellZ];
                this.processCellPieces(currentCell, this.architect);
            }
        }
    }

    @Override
    protected void handleBlockPlacement(BlockWithMeta blockWithMeta, ChunkCoordinates position, Random random) {
        TileEntity tileEntity;
        if (blockWithMeta == null || !this.world.func_72899_e(position.field_71574_a, position.field_71572_b, position.field_71573_c)) {
            blockWithMeta = new BlockWithMeta(Blocks.field_150350_a);
        }
        if ((tileEntity = this.world.func_147438_o(position.field_71574_a, position.field_71572_b, position.field_71573_c)) != null) {
            tileEntity.func_145843_s();
            this.world.func_147475_p(position.field_71574_a, position.field_71572_b, position.field_71573_c);
            this.world.func_147449_b(position.field_71574_a, position.field_71572_b, position.field_71573_c, Block.func_149684_b((String)"air"));
        } else {
            blockWithMeta.placeBlock(this.world, position, random);
        }
    }
}

