/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.buildingmanager;

import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.core.terrain.TerrainFeature;
import com.stek101.projectzulu.common.world2.MazeCell;
import com.stek101.projectzulu.common.world2.architect.ArchitectLabyrinth;
import com.stek101.projectzulu.common.world2.buildingmanager.BuildingManagerBase;
import com.stek101.projectzulu.common.world2.randomizer.Randomizer;
import com.stek101.projectzulu.common.world2.randomizer.WalledMazeRandomizer;
import java.awt.Point;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BuildingManagerLabyrinth
extends BuildingManagerBase {
    public ArchitectLabyrinth architect;
    public Randomizer randomizer;
    MazeCell[][] labyrinth;
    MazeCell[][] stairs;

    public BuildingManagerLabyrinth(World world, ChunkCoordinates startingPos, TerrainFeature.FeatureDirection direction) {
        super(world);
        int j;
        int i;
        this.architect = new ArchitectLabyrinth(world);
        this.randomizer = new WalledMazeRandomizer(world);
        int xCells = 15;
        int zCells = 15;
        int cellSize = 3;
        int cellHeight = 5;
        int stairZCells = MathHelper.func_76123_f((float)(15.0f / (float)cellHeight));
        int stairCellSize = cellSize + 2;
        int stairCellHeight = stairCellSize * 2;
        startingPos = this.calcTranslatedPosition(direction, startingPos, xCells * cellSize, zCells * cellSize + stairZCells * stairCellSize, cellHeight);
        this.stairs = new MazeCell[1][stairZCells];
        for (i = 0; i < this.stairs.length; ++i) {
            for (j = 0; j < this.stairs[0].length; ++j) {
                this.stairs[i][j] = new MazeCell(stairCellSize, stairCellHeight, new ChunkCoordinates(startingPos.field_71574_a - 1 + stairCellSize * i + cellSize * (xCells / 2), startingPos.field_71572_b + 1 + stairCellSize * (this.stairs[0].length - 1 - j), startingPos.field_71573_c + stairCellSize * j));
            }
        }
        this.labyrinth = new MazeCell[xCells][zCells];
        for (i = 0; i < this.labyrinth.length; ++i) {
            for (j = 0; j < this.labyrinth[0].length; ++j) {
                this.labyrinth[i][j] = new MazeCell(cellSize, cellHeight, new ChunkCoordinates(startingPos.field_71574_a + cellSize * i, startingPos.field_71572_b, startingPos.field_71573_c + stairCellSize * this.stairs[0].length + cellSize * j));
            }
        }
    }

    @Override
    protected void randomizeCells() {
        this.randomizer.randomize(this.labyrinth);
    }

    @Override
    protected void assignBlueprints(int pass, int maxPasses) {
        if (pass == maxPasses) {
            int cellZ;
            int cellX;
            for (cellX = 0; cellX < this.labyrinth.length; ++cellX) {
                for (cellZ = 0; cellZ < this.labyrinth[0].length; ++cellZ) {
                    this.architect.assignBlueprint(this.labyrinth, new Point(cellX, cellZ), pass, maxPasses);
                }
            }
            for (cellX = 0; cellX < this.stairs.length; ++cellX) {
                for (cellZ = 0; cellZ < this.stairs[0].length; ++cellZ) {
                    this.architect.assignStairs(this.stairs, new Point(cellX, cellZ), pass, maxPasses);
                }
            }
        }
    }

    @Override
    protected void construct() {
        MazeCell currentCell;
        int cellZ;
        int cellX;
        ProjectZuluLog.info("construct", new Object[0]);
        for (cellX = 0; cellX < this.labyrinth.length; ++cellX) {
            for (cellZ = 0; cellZ < this.labyrinth[0].length; ++cellZ) {
                currentCell = this.labyrinth[cellX][cellZ];
                this.processCellPieces(currentCell, this.architect);
            }
        }
        for (cellX = 0; cellX < this.stairs.length; ++cellX) {
            for (cellZ = 0; cellZ < this.stairs[0].length; ++cellZ) {
                currentCell = this.stairs[cellX][cellZ];
                this.processCellPieces(currentCell, this.architect);
            }
        }
    }
}

