/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.buildingmanager;

import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.core.terrain.TerrainFeature;
import com.stek101.projectzulu.common.world2.MazeCell;
import com.stek101.projectzulu.common.world2.architect.ArchitectPyramid;
import com.stek101.projectzulu.common.world2.buildingmanager.BuildingManagerBase;
import com.stek101.projectzulu.common.world2.randomizer.Randomizer;
import com.stek101.projectzulu.common.world2.randomizer.WalledMazeRandomizer;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class BuildingManagerPyramid
extends BuildingManagerBase {
    int outside_height = 25;
    int floor_height = 3;
    public ArchitectPyramid architect;
    public Randomizer randomizer;
    List<MazeCell[][]> pyramidCells = new ArrayList<MazeCell[][]>();

    public BuildingManagerPyramid(World world, ChunkCoordinates startingPos, TerrainFeature.FeatureDirection direction) {
        super(world);
        int i;
        this.architect = new ArchitectPyramid(world);
        this.randomizer = new WalledMazeRandomizer(world);
        int xCells = 20;
        int zCells = 20;
        int cellSize = 2;
        int cellHeight = 2 * cellSize;
        int floors = (xCells > zCells ? xCells : zCells) / cellHeight + 1;
        startingPos = this.calcTranslatedPosition(direction, startingPos, xCells * cellSize, zCells * cellSize, cellHeight);
        Point numCells = new Point(xCells, zCells);
        for (i = 0; i < floors; ++i) {
            if (numCells.x - i * 4 < 2) continue;
            this.pyramidCells.add(new MazeCell[numCells.x - i * 4][numCells.y - i * 4]);
        }
        for (i = 0; i < this.pyramidCells.size(); ++i) {
            this.initializeMazeCell(this.pyramidCells.get(i), new ChunkCoordinates(startingPos.field_71574_a + 2 * cellSize * i, startingPos.field_71572_b + cellHeight * i, startingPos.field_71573_c + 2 * cellSize * i), cellSize, cellHeight);
        }
    }

    private void initializeMazeCell(MazeCell[][] cells, ChunkCoordinates startingPos, int cellSize, int cellHeight) {
        for (int i = 0; i < cells.length; ++i) {
            for (int j = 0; j < cells[0].length; ++j) {
                cells[i][j] = new MazeCell(cellSize, cellHeight, new ChunkCoordinates(startingPos.field_71574_a + cellSize * i, startingPos.field_71572_b, startingPos.field_71573_c + cellSize * j));
            }
        }
    }

    @Override
    protected void randomizeCells() {
        for (int i = 0; i < this.pyramidCells.size(); ++i) {
            this.markEdgesAsWalls(this.pyramidCells.get(i), 2);
            this.randomizer.randomize(this.pyramidCells.get(i));
        }
    }

    private void markEdgesAsWalls(MazeCell[][] cells, int depth) {
        for (int i = 0; i < cells.length; ++i) {
            int k;
            for (k = 0; k < depth; ++k) {
                cells[i][k].rawState = 1;
            }
            for (k = cells[0].length - depth; k < cells[0].length; ++k) {
                cells[i][k].rawState = 1;
            }
        }
        for (int k = 0; k < cells[0].length; ++k) {
            int i;
            for (i = 0; i < depth; ++i) {
                cells[i][k].rawState = 1;
            }
            for (i = cells.length - depth; i < cells.length; ++i) {
                cells[i][k].rawState = 1;
            }
        }
    }

    @Override
    protected void assignBlueprints(int pass, int maxPasses) {
        if (pass == maxPasses) {
            ProjectZuluLog.info("assignBlueprints", new Object[0]);
            for (int i = 0; i < this.pyramidCells.size(); ++i) {
                this.assignBlueprints(this.pyramidCells.get(i), pass, maxPasses);
                if (i <= 0) continue;
                this.architect.assignStairs(this.pyramidCells.get(i - 1), this.pyramidCells.get(i));
            }
        }
    }

    private void assignBlueprints(MazeCell[][] cells, int pass, int maxPasses) {
        for (int cellX = 0; cellX < cells.length; ++cellX) {
            for (int cellZ = 0; cellZ < cells[0].length; ++cellZ) {
                this.architect.assignBlueprint(cells, new Point(cellX, cellZ), pass, maxPasses);
            }
        }
    }

    @Override
    protected void construct() {
        ProjectZuluLog.info("construct", new Object[0]);
        for (int i = 0; i < this.pyramidCells.size(); ++i) {
            this.construct(this.pyramidCells.get(i));
        }
    }

    private void construct(MazeCell[][] cells) {
        for (int cellX = 0; cellX < cells.length; ++cellX) {
            for (int cellZ = 0; cellZ < cells[0].length; ++cellZ) {
                MazeCell currentCell = cells[cellX][cellZ];
                this.processCellPieces(currentCell, this.architect);
            }
        }
    }
}

