/*
 * Decompiled with CFR 0.152.
 */
package openmods.reflection;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeUtils {
    public static final TypeVariable<?> LIST_VALUE_PARAM;
    public static final TypeVariable<?> MAP_KEY_PARAM;
    public static final TypeVariable<?> MAP_VALUE_PARAM;
    public static final TypeVariable<?> SET_VALUE_PARAM;
    public static final TypeVariable<?> COLLECTION_VALUE_PARAM;
    public static final TypeToken<?> MAP_TOKEN;
    public static final TypeToken<?> SET_TOKEN;
    public static final TypeToken<?> COLLECTION_TOKEN;
    public static final TypeToken<?> LIST_TOKEN;
    public static final BiMap<Class<?>, Class<?>> PRIMITIVE_TYPES_MAP;

    public static Class<?> toObjectType(Class<?> cls) {
        return cls.isPrimitive() ? (Class)PRIMITIVE_TYPES_MAP.get(cls) : cls;
    }

    public static void isInstance(Object o, Class<?> mainCls, Class<?> ... extraCls) {
        Preconditions.checkArgument((boolean)mainCls.isInstance(o), (String)"%s is not instance of %s", (Object[])new Object[]{o, mainCls});
        for (Class<?> cls : extraCls) {
            Preconditions.checkArgument((boolean)cls.isInstance(o), (String)"%s is not instance of %s", (Object[])new Object[]{o, cls});
        }
    }

    public static boolean compareTypes(Class<?> left, Class<?> right) {
        if (left.isPrimitive()) {
            left = (Class)PRIMITIVE_TYPES_MAP.get(left);
        }
        if (right.isPrimitive()) {
            right = (Class)PRIMITIVE_TYPES_MAP.get(right);
        }
        return left.equals(right);
    }

    public static TypeToken<?> getTypeParameter(Class<?> intfClass, Class<?> instanceClass, int index) {
        TypeVariable<Class<?>>[] typeParameters = intfClass.getTypeParameters();
        Preconditions.checkElementIndex((int)index, (int)typeParameters.length, (String)(intfClass + " type parameter index"));
        TypeVariable<Class<?>> arg = typeParameters[index];
        TypeToken type = TypeToken.of(instanceClass);
        Preconditions.checkArgument((type.getRawType() != Object.class ? 1 : 0) != 0, (String)"Type %s is no fully parametrized", (Object[])new Object[]{instanceClass});
        return type.resolveType(arg);
    }

    public static TypeToken<?> getTypeParameter(Class<?> intfClass, Class<?> instanceClass) {
        return TypeUtils.getTypeParameter(intfClass, instanceClass, 0);
    }

    public static TypeToken<?> resolveFieldType(Class<?> cls, Field field) {
        Type fieldType = field.getGenericType();
        TypeToken parentType = TypeToken.of(cls);
        return parentType.resolveType(fieldType);
    }

    static {
        MAP_TOKEN = TypeToken.of(Map.class);
        SET_TOKEN = TypeToken.of(Set.class);
        COLLECTION_TOKEN = TypeToken.of(Collection.class);
        LIST_TOKEN = TypeToken.of(List.class);
        TypeVariable<Class<T>>[] vars = Map.class.getTypeParameters();
        MAP_KEY_PARAM = vars[0];
        MAP_VALUE_PARAM = vars[1];
        LIST_VALUE_PARAM = List.class.getTypeParameters()[0];
        SET_VALUE_PARAM = Set.class.getTypeParameters()[0];
        COLLECTION_VALUE_PARAM = Collection.class.getTypeParameters()[0];
        PRIMITIVE_TYPES_MAP = ImmutableBiMap.builder().put(Boolean.TYPE, Boolean.class).put(Byte.TYPE, Byte.class).put(Character.TYPE, Character.class).put(Short.TYPE, Short.class).put(Integer.TYPE, Integer.class).put(Long.TYPE, Long.class).put(Float.TYPE, Float.class).put(Double.TYPE, Double.class).put(Void.TYPE, Void.class).build();
    }
}

