/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import cpw.mods.fml.common.registry.GameData;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import openmods.sync.ISyncableValueProvider;
import openmods.sync.SyncableObjectBase;
import openmods.utils.ByteUtils;

public class SyncableBlock
extends SyncableObjectBase
implements ISyncableValueProvider<Block> {
    private Block block;

    @Override
    public void readFromStream(DataInputStream stream) {
        int blockId = ByteUtils.readVLI(stream);
        this.block = Block.func_149729_e((int)blockId);
    }

    @Override
    public void writeToStream(DataOutputStream stream) {
        int blockId = Block.func_149682_b((Block)this.block);
        if (blockId < 0) {
            blockId = 0;
        }
        ByteUtils.writeVLI(stream, blockId);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String name) {
        String blockName = GameData.getBlockRegistry().func_148750_c((Object)this.block);
        if (!Strings.isNullOrEmpty((String)blockName)) {
            nbt.func_74778_a(name, blockName);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String name) {
        String blockName = nbt.func_74779_i(name);
        if (!Strings.isNullOrEmpty((String)blockName)) {
            this.block = (Block)GameData.getBlockRegistry().func_82594_a(blockName);
        }
    }

    @Override
    public Block getValue() {
        return (Block)Objects.firstNonNull((Object)this.block, (Object)Blocks.field_150350_a);
    }

    public void setValue(Block block) {
        if (this.block != block) {
            this.block = (Block)Objects.firstNonNull((Object)block, (Object)Blocks.field_150350_a);
            this.markDirty();
        }
    }

    public boolean containsValidBlock() {
        return this.block != null && this.block != Blocks.field_150350_a;
    }
}

