/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import java.util.Calendar;
import java.util.GregorianCalendar;

public class HolidayHelper {
    static Calendar curTime = Calendar.getInstance();
    static Calendar holidayStart = Calendar.getInstance();
    static Calendar holidayEnd = Calendar.getInstance();

    private HolidayHelper() {
    }

    public static boolean isNewYear() {
        HolidayHelper.setDate(holidayStart, 11, 31, false);
        HolidayHelper.setDate(holidayEnd, 0, 2, true);
        holidayEnd.set(1, 2);
        curTime = Calendar.getInstance();
        return curTime.after(holidayStart) && curTime.before(holidayEnd);
    }

    public static boolean isValentinesDay() {
        HolidayHelper.setDate(holidayStart, 1, 13, false);
        HolidayHelper.setDate(holidayEnd, 1, 15, true);
        curTime = Calendar.getInstance();
        return curTime.after(holidayStart) && curTime.before(holidayEnd);
    }

    public static boolean isStPatricksDay() {
        HolidayHelper.setDate(holidayStart, 2, 16, false);
        HolidayHelper.setDate(holidayEnd, 2, 18, true);
        curTime = Calendar.getInstance();
        return curTime.after(holidayStart) && curTime.before(holidayEnd);
    }

    public static boolean isAprilFools() {
        HolidayHelper.setDate(holidayStart, 2, 31, false);
        HolidayHelper.setDate(holidayEnd, 3, 2, true);
        curTime = Calendar.getInstance();
        return curTime.after(holidayStart) && curTime.before(holidayEnd);
    }

    public static boolean isEarthDay() {
        HolidayHelper.setDate(holidayStart, 3, 21, false);
        HolidayHelper.setDate(holidayEnd, 3, 23, true);
        curTime = Calendar.getInstance();
        return curTime.after(holidayStart) && curTime.before(holidayEnd);
    }

    public static boolean isEaster() {
        int n;
        int year = Calendar.getInstance().get(1);
        if (year <= 1582) {
            return false;
        }
        int golden = year % 19 + 1;
        int century = year / 100 + 1;
        int x = 3 * century / 4 - 12;
        int z = (8 * century + 5) / 25 - 5;
        int d = 5 * year / 4 - x - 10;
        int epact = (11 * golden + 20 + z - x) % 30;
        if (epact == 25 && golden > 11 || epact == 24) {
            ++epact;
        }
        n += 30 * ((n = 44 - epact) < 21 ? 1 : 0);
        n += 7 - (d + n) % 7;
        GregorianCalendar easterSun = n > 31 ? new GregorianCalendar(year, 3, n - 31) : new GregorianCalendar(year, 2, n);
        HolidayHelper.setDate(holidayStart, easterSun.get(2), easterSun.get(5) - 1, false);
        HolidayHelper.setDate(holidayEnd, easterSun.get(2), easterSun.get(5) + 1, true);
        curTime = Calendar.getInstance();
        return curTime.after(holidayStart) && curTime.before(holidayEnd);
    }

    public static boolean isUSIndependenceDay() {
        HolidayHelper.setDate(holidayStart, 6, 3, false);
        HolidayHelper.setDate(holidayEnd, 6, 5, true);
        curTime = Calendar.getInstance();
        return curTime.after(holidayStart) && curTime.before(holidayEnd);
    }

    public static boolean isHalloween() {
        HolidayHelper.setDate(holidayStart, 9, 30, false);
        HolidayHelper.setDate(holidayEnd, 10, 1, true);
        curTime = Calendar.getInstance();
        return curTime.after(holidayStart) && curTime.before(holidayEnd);
    }

    public static boolean isThanksgiving() {
        return false;
    }

    public static boolean isHanukkah() {
        return false;
    }

    public static boolean isChristmas() {
        HolidayHelper.setDate(holidayStart, 11, 24, false);
        HolidayHelper.setDate(holidayEnd, 11, 26, true);
        curTime = Calendar.getInstance();
        return curTime.after(holidayStart) && curTime.before(holidayEnd);
    }

    static void setDate(Calendar cal, int month, int date, boolean endOfDay) {
        cal.clear();
        cal.set(1, Calendar.getInstance().get(1));
        cal.set(2, month);
        cal.set(5, date);
        if (endOfDay) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        }
    }
}

