/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.api.tileentity.IRedstoneControl;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class RedstoneControlHelper {
    private RedstoneControlHelper() {
    }

    public static NBTTagCompound setItemStackTagRS(NBTTagCompound tag, IRedstoneControl tile) {
        if (tile == null) {
            return null;
        }
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74774_a("RSControl", (byte)tile.getControl().ordinal());
        return tag;
    }

    public static IRedstoneControl.ControlMode getControlFromNBT(NBTTagCompound tag) {
        return tag == null ? IRedstoneControl.ControlMode.DISABLED : IRedstoneControl.ControlMode.values()[tag.func_74771_c("RSControl")];
    }

    public static void addRSControlInformation(ItemStack stack, List<String> list) {
        if (RedstoneControlHelper.hasRSControl(stack)) {
            switch (stack.field_77990_d.func_74771_c("RSControl")) {
                case 0: {
                    list.add(StringHelper.localize("info.cofh.signal") + ": " + "\u00a74" + StringHelper.localize("info.cofh.disabled") + "\u00a7r");
                    return;
                }
                case 1: {
                    list.add(StringHelper.localize("info.cofh.signal") + ": " + "\u00a7a" + StringHelper.localize("info.cofh.enabled") + "\u00a77" + ", " + StringHelper.localize("info.cofh.low") + "\u00a7r");
                    return;
                }
                case 2: {
                    list.add(StringHelper.localize("info.cofh.signal") + ": " + "\u00a7a" + StringHelper.localize("info.cofh.enabled") + "\u00a77" + ", " + StringHelper.localize("info.cofh.high") + "\u00a7r");
                    return;
                }
            }
        }
    }

    public static boolean hasRSControl(ItemStack stack) {
        return stack.field_77990_d == null ? false : stack.field_77990_d.func_74764_b("RSControl");
    }

    public static boolean setControl(ItemStack stack, IRedstoneControl.ControlMode control) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74774_a("RSControl", (byte)control.ordinal());
        return true;
    }

    public static IRedstoneControl.ControlMode getControl(ItemStack stack) {
        return stack.field_77990_d == null ? IRedstoneControl.ControlMode.DISABLED : IRedstoneControl.ControlMode.values()[stack.field_77990_d.func_74771_c("RSControl")];
    }
}

