/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import gcewing.lighting.BaseMod;
import gcewing.lighting.BlockFloodlight;
import gcewing.lighting.BlockFloodlightBeam;
import gcewing.lighting.BlockFloodlightCarbide;
import gcewing.lighting.ContainerFLC;
import gcewing.lighting.Floodlight;
import gcewing.lighting.GregsLightingClient;
import gcewing.lighting.ic2.GregsLightingIC2;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

@Mod(modid="GregsLighting", name="Greg's Lighting", version="1.11.2", acceptableRemoteVersions="[1.11,1.12)")
public class GregsLighting
extends BaseMod<GregsLightingClient> {
    public static final String modName = "GregsLighting";
    public static final int guiFloodlightCarbide = 1;
    public static BlockFloodlightCarbide floodlightCarbide;
    public static BlockFloodlight floodlight;
    public static BlockFloodlightBeam floodlightBeam;
    public static Item calciumCarbide;
    public static Item bonemealAndCharcoal;
    public static Item gasNozzle;
    public static Item glowingIngot;
    public static GregsLighting mod;
    public static boolean ic2Present;

    public GregsLighting() {
        mod = this;
        this.creativeTab = new CreativeTabs("gcewing_lighting:tab"){

            public Item func_78016_d() {
                return Item.func_150898_a((Block)floodlight);
            }
        };
        System.out.printf("GregsLighting: creativeTab = %s\n", this.creativeTab);
    }

    @Override
    GregsLightingClient initClient() {
        return new GregsLightingClient(this);
    }

    @Override
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        if (Loader.isModLoaded((String)"IC2")) {
            ic2Present = true;
            GregsLightingIC2.preInit();
        }
        System.out.printf("GregsLighting.preInit: creativeTab = %s\n", this.creativeTab);
        super.preInit(fMLPreInitializationEvent);
    }

    @Override
    @Mod.EventHandler
    public void init(FMLInitializationEvent fMLInitializationEvent) {
        super.init(fMLInitializationEvent);
    }

    @Override
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        super.postInit(fMLPostInitializationEvent);
    }

    @Override
    void configure() {
        Floodlight.configure(this.config);
    }

    @Override
    protected void registerBlocks() {
        System.out.printf("GregsLighting.registerBlocks: creativeTab = %s\n", this.creativeTab);
        floodlightCarbide = this.newBlock("carbideFloodlight", BlockFloodlightCarbide.class);
        floodlightCarbide.func_149711_c(1.5f);
        floodlightBeam = this.newBlock("floodlightBeam", BlockFloodlightBeam.class);
        floodlightBeam.func_149647_a(null);
        floodlight = this.newBlock("floodlight", BlockFloodlight.class);
        floodlight.func_149711_c(1.5f);
        if (ic2Present) {
            GregsLightingIC2.registerBlocks();
        }
    }

    @Override
    protected void registerItems() {
        calciumCarbide = this.newItem("calciumCarbide");
        bonemealAndCharcoal = this.newItem("bonemealAndCharcoal");
        gasNozzle = this.newItem("gasNozzle");
        glowingIngot = this.newItem("glowingIngot");
        if (ic2Present) {
            GregsLightingIC2.registerItems();
        }
    }

    @Override
    protected void registerRecipes() {
        this.newShapelessRecipe(bonemealAndCharcoal, 1, new ItemStack(Items.field_151100_aR, 1, 15), new ItemStack(Items.field_151044_h, 1, 1));
        if (this.config.getBoolean("options", "enableSimpleFloodlight", true)) {
            this.newRecipe((Block)floodlight, 1, "IrI", "IgI", "GGG", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('g'), glowingIngot, Character.valueOf('G'), Blocks.field_150359_w);
            this.newRecipe(glowingIngot, 1, "GGG", "GgG", "GGG", Character.valueOf('G'), Blocks.field_150426_aN, Character.valueOf('g'), Items.field_151074_bl);
        }
        this.newSmeltingRecipe(calciumCarbide, 1, bonemealAndCharcoal);
        this.newRecipe(gasNozzle, 4, "I", "I", Character.valueOf('I'), Items.field_151042_j);
        this.newRecipe((Block)floodlightCarbide, 1, "CrC", "CnC", "GGG", Character.valueOf('C'), Blocks.field_150347_e, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('n'), gasNozzle, Character.valueOf('G'), Blocks.field_150359_w);
        if (ic2Present) {
            GregsLightingIC2.registerRecipes();
        }
    }

    @Override
    protected void registerContainers() {
        this.addContainer(1, ContainerFLC.class);
    }

    public static void openGuiFloodlightCarbide(World world, int n, int n2, int n3, EntityPlayer entityPlayer) {
        mod.openGui(entityPlayer, 1, world, n, n2, n3);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent serverTickEvent) {
        switch (serverTickEvent.phase) {
            case START: {
                Floodlight.performScheduledBeamUpdates();
            }
        }
    }

    static {
        ic2Present = false;
    }
}

