/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry.drops;

import com.google.gson.JsonObject;
import java.util.List;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties.MobPropertyException;
import toast.mobProperties.api.DropEntry;
import toast.mobProperties.api.IPropertyDrops;
import toast.mobProperties.entry.EntryAbstract;
import toast.mobProperties.entry.MobDropsInfo;

public class EntryDropsDefault
extends EntryAbstract
implements IPropertyDrops {
    private final byte value;

    public EntryDropsDefault(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader) {
        super(node, path);
        String text = FileHelper.readText(node, path, "value", "");
        if (text.equals("true")) {
            this.value = 1;
        } else if (text.equals("false")) {
            this.value = 0;
        } else if (text.equals("equipment")) {
            this.value = (byte)2;
        } else {
            this.value = 1;
            throw new MobPropertyException("Invalid default value! (must be true, false, or equipment)", path);
        }
    }

    @Override
    public String[] getRequiredFields() {
        return new String[]{"value"};
    }

    @Override
    public String[] getOptionalFields() {
        return new String[0];
    }

    @Override
    public void modifyDrops(MobDropsInfo mobDrops) {
        mobDrops.defaultBehavior = this.value;
    }

    @Override
    public void addDrops(List<DropEntry> dropsList, double[] attempts, double chance, List<String> conditions) {
        dropsList.add(new DropEntry(this.value, attempts, chance, conditions));
    }
}

