/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry.drops;

import com.google.gson.JsonObject;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties.MobStats;
import toast.mobProperties.NBTStats;
import toast.mobProperties.entry.EntryAbstract;
import toast.mobProperties.entry.MobDropsInfo;
import toast.mobProperties.entry.MobStatsInfo;

public class EntryDropsSpawn
extends EntryAbstract {
    private final String entityId;
    private final double[] counts;
    private final NBTStats nbtStats;
    private final MobStats entityStats;

    public EntryDropsSpawn(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader) {
        super(node, path);
        this.entityId = FileHelper.readText(node, path, "id", "");
        this.counts = FileHelper.readCounts(node, path, "count", 1.0, 1.0);
        this.nbtStats = new NBTStats(path, root, index, node, loader);
        this.entityStats = new MobStats(path, root, index, node, loader);
    }

    @Override
    public String[] getRequiredFields() {
        return new String[]{"id"};
    }

    @Override
    public String[] getOptionalFields() {
        return new String[]{"count", "tags", "stats"};
    }

    @Override
    public void modifyDrops(MobDropsInfo mobDrops) {
        if (!mobDrops.theEntity.field_70170_p.field_72995_K) {
            int count = FileHelper.getCount(this.counts);
            while (count-- > 0) {
                Entity entity = EntityList.func_75620_a((String)this.entityId, (World)mobDrops.theEntity.field_70170_p);
                if (entity == null) {
                    return;
                }
                this.initEntity(mobDrops.theEntity, entity, mobDrops);
                mobDrops.theEntity.field_70170_p.func_72838_d(entity);
            }
        }
    }

    private void initEntity(EntityLivingBase parentEntity, Entity entity, Object mobInfo) {
        if (this.nbtStats.hasEntries()) {
            NBTTagCompound tag = new NBTTagCompound();
            entity.func_70109_d(tag);
            this.nbtStats.generate(parentEntity, tag, mobInfo);
            entity.func_70020_e(tag);
            entity.func_70107_b(parentEntity.field_70165_t + entity.field_70165_t, parentEntity.field_70163_u + entity.field_70163_u, parentEntity.field_70161_v + entity.field_70161_v);
            entity.field_70177_z = parentEntity.field_70177_z + entity.field_70177_z;
        } else {
            entity.func_70107_b(parentEntity.field_70165_t, parentEntity.field_70163_u, parentEntity.field_70161_v);
            entity.field_70177_z = parentEntity.field_70177_z;
        }
        if (entity instanceof EntityLivingBase) {
            this.entityStats.init(new MobStatsInfo((EntityLivingBase)entity));
        }
    }
}

