/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry.stats;

import com.google.gson.JsonObject;
import toast.mobProperties.EffectHelper;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties.MobPropertyException;
import toast.mobProperties._MobPropertiesMod;
import toast.mobProperties.entry.EntryAbstract;
import toast.mobProperties.entry.ItemStatsInfo;
import toast.mobProperties.entry.MobStatsInfo;

public class EntryStatsModifier
extends EntryAbstract {
    public final String name;
    public final double[] values;
    public final int operation;
    public final boolean override;

    public EntryStatsModifier(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader) {
        super(node, path);
        this.name = FileHelper.readText(node, path, "attribute", "");
        this.values = FileHelper.readCounts(node, path, "value", 0.0, 0.0);
        this.operation = FileHelper.readInteger(node, path, "operator", 0);
        if (this.operation < 0 || this.operation > 2) {
            throw new MobPropertyException("Invalid operator! (" + this.operation + ": 0=add, 1=additive_multiplier, 2=multiplicative_multiplier)", path);
        }
        this.override = FileHelper.readBoolean(node, path, "override", false);
    }

    @Override
    public String[] getRequiredFields() {
        return new String[]{"attribute", "value"};
    }

    @Override
    public String[] getOptionalFields() {
        return new String[]{"operator", "override"};
    }

    @Override
    public void init(MobStatsInfo mobStats) {
        double value = FileHelper.getValue(this.values, mobStats.random);
        if (this.override) {
            if (mobStats.theEntity.func_110140_aT().func_111152_a(this.name) == null) {
                _MobPropertiesMod.debugException("Attempted to override invalid attribute \"" + this.name + "\" for " + mobStats.theEntity.toString());
            } else {
                mobStats.theEntity.func_110140_aT().func_111152_a(this.name).func_111128_a(value);
            }
        } else {
            mobStats.addModifier(this.name, value, this.operation);
        }
    }

    @Override
    public void modifyItem(ItemStatsInfo itemStats) {
        double value = FileHelper.getValue(this.values, itemStats.random);
        EffectHelper.addModifier(itemStats.theItem, this.name, value, this.operation);
    }
}

