/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry.stats;

import com.google.gson.JsonObject;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties.MobStats;
import toast.mobProperties.NBTStats;
import toast.mobProperties.entry.EntryAbstract;
import toast.mobProperties.entry.MobStatsInfo;

public class EntryStatsRiding
extends EntryAbstract {
    private final boolean isMount;
    private final String entityId;
    private final NBTStats nbtStats;
    private final MobStats entityStats;

    public EntryStatsRiding(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader, boolean riding) {
        super(node, path);
        this.isMount = riding;
        this.entityId = FileHelper.readText(node, path, "id", "");
        this.nbtStats = new NBTStats(path, root, index, node, loader);
        this.entityStats = new MobStats(path, root, index, node, loader);
    }

    @Override
    public String[] getRequiredFields() {
        return new String[]{"id"};
    }

    @Override
    public String[] getOptionalFields() {
        return new String[]{"tags", "stats"};
    }

    @Override
    public void init(MobStatsInfo mobStats) {
        if (!mobStats.theEntity.field_70170_p.field_72995_K) {
            Entity entity = EntityList.func_75620_a((String)this.entityId, (World)mobStats.theEntity.field_70170_p);
            if (entity == null) {
                return;
            }
            entity.field_70177_z = mobStats.theEntity.field_70177_z;
            entity.func_70107_b(mobStats.theEntity.field_70165_t, mobStats.theEntity.field_70163_u, mobStats.theEntity.field_70161_v);
            this.initEntity(mobStats.theEntity, entity, mobStats);
            if (this.isMount) {
                mobStats.theEntity.func_70078_a(entity);
            } else {
                entity.func_70078_a((Entity)mobStats.theEntity);
            }
            mobStats.theEntity.field_70170_p.func_72838_d(entity);
        }
    }

    private void initEntity(EntityLivingBase parentEntity, Entity entity, Object mobInfo) {
        if (this.nbtStats.hasEntries()) {
            NBTTagCompound tag = new NBTTagCompound();
            entity.func_70109_d(tag);
            this.nbtStats.generate(parentEntity, tag, mobInfo);
            entity.func_70020_e(tag);
        }
        if (entity instanceof EntityLivingBase) {
            this.entityStats.init(new MobStatsInfo((EntityLivingBase)entity));
        }
    }
}

