/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker.foodgroups;

import com.google.gson.annotations.SerializedName;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import squeek.spiceoflife.compat.IByteIO;
import squeek.spiceoflife.foodtracker.FoodModifier;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupMember;
import squeek.spiceoflife.interfaces.IPackable;

public class FoodGroup
implements IPackable {
    public transient String identifier;
    private transient List<FoodGroupMember> foods = new ArrayList<FoodGroupMember>();
    private transient FoodModifier foodModifier;
    public boolean enabled = true;
    public String name = null;
    public int priority = 0;
    public boolean blacklist = false;
    public boolean hidden = false;
    public String formula = null;
    @SerializedName(value="food")
    public Map<String, List<String>> foodStringsByType;

    public FoodGroup() {
    }

    public FoodGroup(String identifier, String name, int priority) {
        this.identifier = identifier;
        this.name = name;
        this.priority = priority;
    }

    public void initFromConfig() {
        List<String> itemStrings;
        List<String> oredictStrings = this.foodStringsByType.get("oredict");
        if (oredictStrings != null) {
            for (String oredictString : oredictStrings) {
                this.addFood(oredictString);
            }
        }
        if ((itemStrings = this.foodStringsByType.get("items")) != null) {
            for (String itemString : itemStrings) {
                this.addItemFromString(itemString);
            }
        }
    }

    public void init() {
        for (FoodGroupMember foodMember : this.foods) {
            foodMember.initMatchingItemsList();
        }
        this.foodModifier = this.formula != null ? new FoodModifier(this.formula) : FoodModifier.GLOBAL;
    }

    public boolean isFoodIncluded(ItemStack food) {
        for (FoodGroupMember foodMember : this.foods) {
            if (!foodMember.isFoodIncluded(food)) continue;
            return true;
        }
        return false;
    }

    public String getLocalizedName() {
        if (this.name != null) {
            return StatCollector.func_74838_a((String)this.name);
        }
        return StatCollector.func_74838_a((String)("spiceoflife.foodgroup." + this.identifier));
    }

    public FoodModifier getFoodModifier() {
        return this.foodModifier;
    }

    public void addFood(String oredictName) {
        this.addFood(oredictName, false);
    }

    public void addFood(String oredictName, boolean baseItemForRecipes) {
        this.addFood(new FoodGroupMember(oredictName, baseItemForRecipes));
    }

    public void addFood(ItemStack itemStack, boolean exactMetadata) {
        this.addFood(itemStack, exactMetadata, false);
    }

    public void addFood(ItemStack itemStack, boolean exactMetadata, boolean baseItemForRecipes) {
        this.addFood(new FoodGroupMember(itemStack, exactMetadata, baseItemForRecipes));
    }

    public void addFood(FoodGroupMember foodMember) {
        this.foods.add(foodMember);
    }

    public void addItemFromString(String itemString) {
        this.addItemFromString(itemString, false);
    }

    public void addItemFromString(String itemString, boolean isBaseItem) {
        Item item;
        String[] itemStringParts = itemString.split(":");
        if (itemStringParts.length > 1 && (item = GameRegistry.findItem((String)itemStringParts[0], (String)itemStringParts[1])) != null) {
            boolean exactMetadata = itemStringParts.length > 2 && itemStringParts[2] != "*";
            int metadata = itemStringParts.length > 2 && exactMetadata ? Integer.parseInt(itemStringParts[2]) : 0;
            this.addFood(new ItemStack(item, 1, metadata), exactMetadata, isBaseItem);
        }
    }

    @Override
    public void pack(IByteIO data) {
        data.writeUTF(this.identifier);
        data.writeUTF(this.name != null ? this.name : "");
        data.writeUTF(this.formula != null ? this.formula : "");
        data.writeShort(this.priority);
        data.writeBoolean(this.blacklist);
        data.writeBoolean(this.hidden);
        data.writeShort(this.foods.size());
        for (FoodGroupMember foodMember : this.foods) {
            foodMember.pack(data);
        }
    }

    @Override
    public void unpack(IByteIO data) {
        this.identifier = data.readUTF();
        this.name = data.readUTF();
        this.name = !this.name.equals("") ? this.name : null;
        this.formula = data.readUTF();
        this.formula = !this.formula.equals("") ? this.formula : null;
        this.priority = data.readShort();
        this.blacklist = data.readBoolean();
        this.hidden = data.readBoolean();
        int size = data.readShort();
        for (int i = 0; i < size; ++i) {
            FoodGroupMember foodMember = new FoodGroupMember();
            foodMember.unpack(data);
            this.addFood(foodMember);
        }
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof FoodGroup) {
            return ((FoodGroup)obj).identifier.equals(this.identifier);
        }
        return false;
    }
}

