/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker.foodgroups;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.FilenameUtils;
import squeek.spiceoflife.ModSpiceOfLife;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroup;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.helpers.FileHelper;

public class FoodGroupConfig {
    private static final Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();
    private static File[] configFiles;

    public static void setup(File configDirectory) {
        File modConfigDirectory = new File(configDirectory, "SpiceOfLife");
        if (!modConfigDirectory.exists()) {
            modConfigDirectory.mkdirs();
        }
        FoodGroupConfig.writeExampleFoodGroup(modConfigDirectory);
        configFiles = modConfigDirectory.listFiles();
    }

    public static void writeExampleFoodGroup(File configDirectory) {
        String exampleFoodGroupFileName = "example-food-group.json";
        String exampleFoodGroupRelativePath = "example/example-food-group.json";
        File exampleFoodGroupDest = new File(configDirectory, "example-food-group.json");
        try {
            boolean shouldOverwrite = FoodGroupConfig.shouldOverwriteExampleFoodGroup(exampleFoodGroupDest);
            if (ModSpiceOfLife.instance.sourceFile.isDirectory()) {
                File sourceFile = new File(ModSpiceOfLife.instance.sourceFile, "example/example-food-group.json");
                FileHelper.copyFile(sourceFile, exampleFoodGroupDest, shouldOverwrite);
            } else {
                InputStream exampleFoodGroupInputStream = FoodGroupConfig.class.getClassLoader().getResourceAsStream("example/example-food-group.json");
                FileHelper.copyFile(exampleFoodGroupInputStream, exampleFoodGroupDest, shouldOverwrite);
                exampleFoodGroupInputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean shouldOverwriteExampleFoodGroup(File exampleFoodGroup) throws IOException {
        FileInputStream exampleFoodGroupStream;
        try {
            exampleFoodGroupStream = new FileInputStream(exampleFoodGroup);
        }
        catch (FileNotFoundException e) {
            return true;
        }
        BufferedReader exampleFoodGroupReader = new BufferedReader(new InputStreamReader(exampleFoodGroupStream));
        String firstLine = exampleFoodGroupReader.readLine();
        exampleFoodGroupReader.close();
        return firstLine == null || !firstLine.equals("// Mod Version: 1.2.4");
    }

    public static void load() {
        for (File configFile : configFiles) {
            try {
                FileReader reader = new FileReader(configFile);
                FoodGroup foodGroup = (FoodGroup)gson.fromJson((Reader)reader, FoodGroup.class);
                if (foodGroup != null && foodGroup.enabled) {
                    foodGroup.identifier = FilenameUtils.removeExtension((String)configFile.getName());
                    foodGroup.initFromConfig();
                    FoodGroupRegistry.addFoodGroup(foodGroup);
                }
                reader.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

