/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ModConfig {
    public static final ModConfig instance = new ModConfig();
    private static Configuration config;
    private static final String CATEGORY_CLIENT = "client";
    private static final String CATEGORY_CLIENT_COMMENT = "These config settings are client-side only";
    public static boolean SHOW_FOOD_VALUES_IN_TOOLTIP;
    private static final String SHOW_FOOD_VALUES_IN_TOOLTIP_NAME = "show.food.values.in.tooltip";
    private static final String SHOW_FOOD_VALUES_IN_TOOLTIP_COMMENT = "If true, shows the hunger and saturation values of food in its tooltip while holding SHIFT";
    public static boolean SHOW_SATURATION_OVERLAY;
    private static final String SHOW_SATURATION_OVERLAY_NAME = "show.saturation.hud.overlay";
    private static final String SHOW_SATURATION_OVERLAY_COMMENT = "If true, shows your current saturation level overlayed on the hunger bar";
    public static boolean SHOW_FOOD_VALUES_OVERLAY;
    private static final String SHOW_FOOD_VALUES_OVERLAY_NAME = "show.food.values.hud.overlay";
    private static final String SHOW_FOOD_VALUES_OVERLAY_COMMENT = "If true, shows the hunger (and saturation if show.saturation.hud.overlay is true) that would be restored by food you are currently holding";
    @Deprecated
    private static final String SHOW_FOOD_EXHAUSTION_OVERLAY_NAME = "show.food.exhaustion.hud.overlay";
    public static boolean SHOW_FOOD_EXHAUSTION_UNDERLAY;
    private static final String SHOW_FOOD_EXHAUSTION_UNDERLAY_NAME = "show.food.exhaustion.hud.underlay";
    private static final String SHOW_FOOD_EXHAUSTION_UNDERLAY_COMMENT = "If true, shows your food exhaustion as a progress bar behind the hunger bars";
    public static boolean SHOW_FOOD_DEBUG_INFO;
    private static final String SHOW_FOOD_DEBUG_INFO_NAME = "show.food.stats.in.debug.overlay";
    private static final String SHOW_FOOD_DEBUG_INFO_COMMENT = "If true, adds a line that shows your hunger, saturation, and exhaustion level in the F3 debug overlay";

    protected ModConfig() {
    }

    public static void init(File file) {
        config = new Configuration(file);
        ModConfig.load();
        config.getCategory(CATEGORY_CLIENT).setComment(CATEGORY_CLIENT_COMMENT);
        boolean foodExhaustionOverlayValue = config.get(CATEGORY_CLIENT, SHOW_FOOD_EXHAUSTION_OVERLAY_NAME, true).getBoolean(true);
        config.getCategory(CATEGORY_CLIENT).remove((Object)SHOW_FOOD_EXHAUSTION_OVERLAY_NAME);
        SHOW_FOOD_VALUES_IN_TOOLTIP = config.get(CATEGORY_CLIENT, SHOW_FOOD_VALUES_IN_TOOLTIP_NAME, true, SHOW_FOOD_VALUES_IN_TOOLTIP_COMMENT).getBoolean(true);
        SHOW_SATURATION_OVERLAY = config.get(CATEGORY_CLIENT, SHOW_SATURATION_OVERLAY_NAME, true, SHOW_SATURATION_OVERLAY_COMMENT).getBoolean(true);
        SHOW_FOOD_VALUES_OVERLAY = config.get(CATEGORY_CLIENT, SHOW_FOOD_VALUES_OVERLAY_NAME, true, SHOW_FOOD_VALUES_OVERLAY_COMMENT).getBoolean(true);
        SHOW_FOOD_EXHAUSTION_UNDERLAY = config.get(CATEGORY_CLIENT, SHOW_FOOD_EXHAUSTION_UNDERLAY_NAME, foodExhaustionOverlayValue, SHOW_FOOD_EXHAUSTION_UNDERLAY_COMMENT).getBoolean(foodExhaustionOverlayValue);
        SHOW_FOOD_DEBUG_INFO = config.get(CATEGORY_CLIENT, SHOW_FOOD_DEBUG_INFO_NAME, true, SHOW_FOOD_DEBUG_INFO_COMMENT).getBoolean(true);
        ModConfig.save();
    }

    public static void save() {
        config.save();
    }

    public static void load() {
        config.load();
    }

    static {
        SHOW_FOOD_VALUES_IN_TOOLTIP = true;
        SHOW_SATURATION_OVERLAY = true;
        SHOW_FOOD_VALUES_OVERLAY = true;
        SHOW_FOOD_EXHAUSTION_UNDERLAY = true;
        SHOW_FOOD_DEBUG_INFO = true;
    }
}

