/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.asm.module;

import cpw.mods.fml.common.eventhandler.Event;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.applecore.asm.Hooks;
import squeek.applecore.asm.IClassTransformerModule;
import squeek.asmhelper.ASMHelper;

public class ModulePlantGrowth
implements IClassTransformerModule {
    @Override
    public String[] getClassesToTransform() {
        return new String[]{"net.minecraft.block.BlockCrops", "net.minecraft.block.BlockReed", "net.minecraft.block.BlockCactus", "net.minecraft.block.BlockCocoa", "net.minecraft.block.BlockMushroom", "net.minecraft.block.BlockNetherWart", "net.minecraft.block.BlockSapling", "net.minecraft.block.BlockStem", "com.pam.harvestcraft.BlockPamFruit", "com.pam.harvestcraft.BlockPamSapling", "mods.natura.blocks.crops.BerryBush", "mods.natura.blocks.crops.NetherBerryBush", "mods.natura.blocks.crops.CropBlock", "mods.natura.blocks.crops.Glowshroom"};
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        boolean isObfuscated = !name.equals(transformedName);
        ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
        MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, isObfuscated ? "a" : "updateTick", isObfuscated ? "(Lahb;IIILjava/util/Random;)V" : "(Lnet/minecraft/world/World;IIILjava/util/Random;)V");
        if (methodNode == null) {
            methodNode = ASMHelper.findMethodNodeOfClass(classNode, "func_149674_a", isObfuscated ? "(Lahb;IIILjava/util/Random;)V" : "(Lnet/minecraft/world/World;IIILjava/util/Random;)V");
        }
        if (methodNode == null) {
            throw new RuntimeException(classNode.name + ": updateTick method not found");
        }
        if (transformedName.equals("net.minecraft.block.BlockCrops")) {
            this.hookBlockCrops(classNode, methodNode, isObfuscated);
        } else if (transformedName.equals("net.minecraft.block.BlockReed")) {
            this.hookBlockReed(classNode, methodNode, isObfuscated);
        } else if (transformedName.equals("net.minecraft.block.BlockCactus")) {
            this.hookBlockCactus(classNode, methodNode, isObfuscated);
        } else if (transformedName.equals("net.minecraft.block.BlockCocoa")) {
            this.hookBlockCocoa(classNode, methodNode, isObfuscated);
        } else if (transformedName.equals("net.minecraft.block.BlockMushroom")) {
            this.hookBlockMushroom(classNode, methodNode, isObfuscated);
        } else if (transformedName.equals("net.minecraft.block.BlockNetherWart")) {
            this.hookBlockNetherWart(classNode, methodNode, isObfuscated);
        } else if (transformedName.equals("net.minecraft.block.BlockSapling")) {
            this.hookBlockSapling(classNode, methodNode, isObfuscated);
        } else if (transformedName.equals("net.minecraft.block.BlockStem")) {
            this.hookBlockStem(classNode, methodNode, isObfuscated);
        } else if (transformedName.equals("com.pam.harvestcraft.BlockPamFruit")) {
            this.hookBlockPamFruit(classNode, methodNode, isObfuscated);
        } else if (transformedName.equals("com.pam.harvestcraft.BlockPamSapling")) {
            this.hookBlockPamSapling(classNode, methodNode, isObfuscated);
        } else if (transformedName.equals("mods.natura.blocks.crops.BerryBush") || transformedName.equals("mods.natura.blocks.crops.NetherBerryBush")) {
            this.hookBlockNaturaBerryBush(classNode, methodNode, isObfuscated);
        } else if (transformedName.equals("mods.natura.blocks.crops.CropBlock")) {
            this.hookNaturaCropBlock(classNode, methodNode, isObfuscated);
        } else if (transformedName.equals("mods.natura.blocks.crops.Glowshroom")) {
            this.hookBlockMushroom(classNode, methodNode, isObfuscated);
        } else {
            return basicClass;
        }
        return ASMHelper.writeClassToBytes(classNode);
    }

    private void hookBlockCrops(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 161);
        AbstractInsnNode ifStartPoint = ASMHelper.findPreviousLabelOrLineNumber((AbstractInsnNode)ifJumpInsn).getNext();
        LabelNode endLabel = ASMHelper.findEndLabel(method);
        LabelNode ifFailedLabel = ifJumpInsn.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ifStartPoint, endLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        ifStartPoint = ASMHelper.findPreviousLabelOrLineNumber(ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)ifJumpInsn, 18)).getNext();
        ifJumpInsn = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode(ifStartPoint, 154);
        ifFailedLabel = ifJumpInsn.label;
        ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel);
    }

    private void hookBlockReed(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 162);
        LabelNode ifDeniedLabel = ifJumpInsn.label;
        this.injectNotDeniedCheckBefore(method, ifJumpInsn.getNext(), ifDeniedLabel);
        LabelNode newGotoLabel = new LabelNode();
        JumpInsnNode gotoInsn = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)ifJumpInsn, 167);
        gotoInsn.label = newGotoLabel;
        method.instructions.insertBefore((AbstractInsnNode)ifDeniedLabel, (AbstractInsnNode)newGotoLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifDeniedLabel);
    }

    private void hookBlockCactus(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 162);
        LabelNode ifDeniedLabel = ifJumpInsn.label;
        this.injectNotDeniedCheckBefore(method, ifJumpInsn.getNext(), ifDeniedLabel);
        LabelNode newGotoLabel = new LabelNode();
        JumpInsnNode gotoInsn = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)ifJumpInsn, 167);
        gotoInsn.label = newGotoLabel;
        method.instructions.insertBefore((AbstractInsnNode)ifDeniedLabel, (AbstractInsnNode)newGotoLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifDeniedLabel);
    }

    private void hookBlockCocoa(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ASMHelper.findFirstInstruction(method), ASMHelper.findEndLabel(method));
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 154);
        ifJumpInsn = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)ifJumpInsn, 154);
        AbstractInsnNode ifStartPoint = ASMHelper.findPreviousLabelOrLineNumber((AbstractInsnNode)ifJumpInsn).getNext();
        LabelNode ifFailedLabel = ifJumpInsn.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel);
    }

    private void hookBlockMushroom(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ASMHelper.findFirstInstruction(method), ASMHelper.findEndLabel(method));
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 154);
        AbstractInsnNode ifStartPoint = ASMHelper.findPreviousLabelOrLineNumber((AbstractInsnNode)ifJumpInsn).getNext();
        LabelNode ifFailedLabel = ifJumpInsn.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        this.fixPrecedingIfsToNotSkipInjectedInstructions(method, ifFailedLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel);
    }

    private void hookBlockNetherWart(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ASMHelper.findFirstInstruction(method), ASMHelper.findEndLabel(method));
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 154);
        AbstractInsnNode ifStartPoint = ASMHelper.findPreviousLabelOrLineNumber((AbstractInsnNode)ifJumpInsn).getNext();
        LabelNode ifFailedLabel = ifJumpInsn.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel);
    }

    private void hookBlockSapling(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        JumpInsnNode lightValueIf = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 161);
        JumpInsnNode randomIf = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)lightValueIf, 154);
        AbstractInsnNode ifStartPoint = ASMHelper.findPreviousLabelOrLineNumber((AbstractInsnNode)lightValueIf).getNext();
        LabelNode ifFailedLabel = lightValueIf.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)randomIf, (AbstractInsnNode)ifAllowedLabel);
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ifStartPoint, ifFailedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel);
    }

    private void hookBlockStem(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        JumpInsnNode lightValueIf = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 161);
        AbstractInsnNode ifStartPoint = ASMHelper.getOrFindInstructionOfType((AbstractInsnNode)lightValueIf, 15, true).getNext();
        LabelNode ifFailedLabel = lightValueIf.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)lightValueIf, (AbstractInsnNode)ifAllowedLabel);
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ifStartPoint, ASMHelper.findEndLabel(method));
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        JumpInsnNode randomIf = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)lightValueIf, 154);
        ifStartPoint = ASMHelper.getOrFindInstructionOfType((AbstractInsnNode)randomIf, 15, true).getNext();
        ifFailedLabel = randomIf.label;
        ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)randomIf, (AbstractInsnNode)ifAllowedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        LabelNode newGotoLabel = new LabelNode();
        JumpInsnNode gotoInsn = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)randomIf, 167);
        gotoInsn.label = newGotoLabel;
        method.instructions.insertBefore((AbstractInsnNode)ifFailedLabel, (AbstractInsnNode)newGotoLabel);
        this.fixPrecedingIfsToNotSkipInjectedInstructions(method, ifFailedLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel);
    }

    private void hookBlockPamFruit(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ASMHelper.findFirstInstruction(method), ASMHelper.findEndLabel(method));
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 154);
        AbstractInsnNode ifStartPoint = ASMHelper.findPreviousLabelOrLineNumber((AbstractInsnNode)ifJumpInsn).getNext();
        LabelNode ifFailedLabel = ifJumpInsn.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel);
    }

    private void hookBlockPamSapling(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findLastInstructionWithOpcode(method, 154);
        AbstractInsnNode ifStartPoint = ASMHelper.findPreviousLabelOrLineNumber((AbstractInsnNode)ifJumpInsn).getNext();
        LabelNode ifFailedLabel = ifJumpInsn.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ifStartPoint, ifFailedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel);
    }

    private void hookBlockNaturaBerryBush(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 154);
        AbstractInsnNode ifStartPoint = ASMHelper.findPreviousLabelOrLineNumber((AbstractInsnNode)ifJumpInsn).getNext();
        if (!classNode.name.endsWith("NetherBerryBush")) {
            ifJumpInsn = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)ifJumpInsn, 161);
        }
        LabelNode ifFailedLabel = ifJumpInsn.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ifStartPoint, ifFailedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        this.fixPrecedingIfsToNotSkipInjectedInstructions(method, ifFailedLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel);
    }

    private void hookNaturaCropBlock(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 161);
        AbstractInsnNode ifStartPoint = ASMHelper.findPreviousLabelOrLineNumber((AbstractInsnNode)ifJumpInsn).getNext();
        LabelNode endLabel = ASMHelper.findEndLabel(method);
        LabelNode ifFailedLabel = ifJumpInsn.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ifStartPoint, endLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        ifStartPoint = ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)ifJumpInsn, 18).getPrevious();
        ifJumpInsn = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode(ifStartPoint, 154);
        ifFailedLabel = ifJumpInsn.label;
        ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel);
    }

    private int fireAllowGrowthEventAndStoreResultBefore(MethodNode method, AbstractInsnNode injectPoint, LabelNode endLabel) {
        LabelNode allowGrowthResultStart = new LabelNode();
        LocalVariableNode allowGrowthResult = new LocalVariableNode("allowGrowthResult", Type.getDescriptor(Event.Result.class), null, allowGrowthResultStart, endLabel, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(allowGrowthResult);
        InsnList toInject = new InsnList();
        this.addFireGrowthEventInsnsToList(toInject);
        toInject.add((AbstractInsnNode)new VarInsnNode(58, allowGrowthResult.index));
        toInject.add((AbstractInsnNode)allowGrowthResultStart);
        method.instructions.insertBefore(injectPoint, toInject);
        return allowGrowthResult.index;
    }

    private void addFireGrowthEventInsnsToList(InsnList insnList) {
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
        insnList.add((AbstractInsnNode)new VarInsnNode(21, 2));
        insnList.add((AbstractInsnNode)new VarInsnNode(21, 3));
        insnList.add((AbstractInsnNode)new VarInsnNode(21, 4));
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 5));
        insnList.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "fireAllowPlantGrowthEvent", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/World;IIILjava/util/Random;)Lcpw/mods/fml/common/eventhandler/Event$Result;"));
    }

    private void injectAllowedOrDefaultCheckBefore(MethodNode method, AbstractInsnNode injectPoint, int resultIndex, LabelNode ifAllowedLabel, LabelNode ifFailedLabel) {
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, resultIndex));
        toInject.add((AbstractInsnNode)new FieldInsnNode(178, Type.getInternalName(Event.Result.class), "ALLOW", Type.getDescriptor(Event.Result.class)));
        toInject.add((AbstractInsnNode)new JumpInsnNode(165, ifAllowedLabel));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, resultIndex));
        toInject.add((AbstractInsnNode)new FieldInsnNode(178, Type.getInternalName(Event.Result.class), "DEFAULT", Type.getDescriptor(Event.Result.class)));
        toInject.add((AbstractInsnNode)new JumpInsnNode(166, ifFailedLabel));
        method.instructions.insertBefore(injectPoint, toInject);
    }

    private void injectNotDeniedCheckBefore(MethodNode method, AbstractInsnNode injectPoint, LabelNode ifDeniedLabel) {
        InsnList toInject = new InsnList();
        this.addFireGrowthEventInsnsToList(toInject);
        toInject.add((AbstractInsnNode)new FieldInsnNode(178, Type.getInternalName(Event.Result.class), "DENY", Type.getDescriptor(Event.Result.class)));
        toInject.add((AbstractInsnNode)new JumpInsnNode(165, ifDeniedLabel));
        method.instructions.insertBefore(injectPoint, toInject);
    }

    private void injectOnGrowthEventBefore(MethodNode method, AbstractInsnNode injectPoint) {
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 2));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 3));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 4));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "fireOnGrowthEvent", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/World;III)V"));
        method.instructions.insertBefore(injectPoint, toInject);
    }

    private void fixPrecedingIfsToNotSkipInjectedInstructions(MethodNode method, LabelNode labelJumpedTo) {
        LabelNode beforeOnGrowthEvent = new LabelNode();
        method.instructions.insertBefore((AbstractInsnNode)labelJumpedTo, (AbstractInsnNode)beforeOnGrowthEvent);
        for (AbstractInsnNode curInsn = labelJumpedTo.getPrevious(); curInsn != null; curInsn = curInsn.getPrevious()) {
            boolean isJump = curInsn instanceof JumpInsnNode;
            if (isJump && ((JumpInsnNode)curInsn).label == labelJumpedTo) {
                ((JumpInsnNode)curInsn).label = beforeOnGrowthEvent;
                continue;
            }
            if (isJump) break;
        }
    }
}

