/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.network.MessageDifficultySync;
import squeek.applecore.network.MessageExhaustionSync;
import squeek.applecore.network.MessageSaturationSync;

public class SyncHandler {
    public static final SimpleNetworkWrapper channel = NetworkRegistry.INSTANCE.newSimpleChannel("AppleCore");
    private float lastSaturationLevel = 0.0f;
    private float lastExhaustionLevel = 0.0f;
    private EnumDifficulty lastDifficultySetting = null;

    public static void init() {
        channel.registerMessage(MessageDifficultySync.class, MessageDifficultySync.class, 0, Side.CLIENT);
        channel.registerMessage(MessageExhaustionSync.class, MessageExhaustionSync.class, 1, Side.CLIENT);
        channel.registerMessage(MessageSaturationSync.class, MessageSaturationSync.class, 2, Side.CLIENT);
        SyncHandler syncHandler = new SyncHandler();
        FMLCommonHandler.instance().bus().register((Object)syncHandler);
        MinecraftForge.EVENT_BUS.register((Object)syncHandler);
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        float exhaustionLevel;
        if (!(event.entity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.entity;
        if (this.lastSaturationLevel != player.func_71024_bL().func_75115_e()) {
            channel.sendTo((IMessage)new MessageSaturationSync(player.func_71024_bL().func_75115_e()), player);
            this.lastSaturationLevel = player.func_71024_bL().func_75115_e();
        }
        if (Math.abs(this.lastExhaustionLevel - (exhaustionLevel = AppleCoreAPI.accessor.getExhaustion((EntityPlayer)player))) >= 0.01f) {
            channel.sendTo((IMessage)new MessageExhaustionSync(exhaustionLevel), player);
            this.lastExhaustionLevel = exhaustionLevel;
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.world instanceof WorldServer && this.lastDifficultySetting != event.world.field_73013_u) {
            channel.sendToAll((IMessage)new MessageDifficultySync(event.world.field_73013_u));
            this.lastDifficultySetting = event.world.field_73013_u;
        }
    }
}

