/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.forestry.handlers;

import forestry.core.utils.ShapedRecipeCustom;
import forestry.factory.gadgets.MachineCarpenter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.forestry.ForestryHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Carpenter")
public class Carpenter {
    public static final String name = "Forestry Carpenter";

    @ZenMethod
    public static void addRecipe(IItemStack output, int packagingTime, IIngredient[][] ingredients, @Optional ILiquidStack fluidInput, @Optional IItemStack box) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new MachineCarpenter.Recipe(packagingTime, InputHelper.toFluid(fluidInput), InputHelper.toStack(box), ShapedRecipeCustom.createShapedRecipe((ItemStack)InputHelper.toStack(output), (Object[])InputHelper.toShapedObjects(ingredients)))));
    }

    @ZenMethod
    public static void addRecipe(int packagingTime, ILiquidStack liquid, IItemStack[] ingredients, IItemStack ingredient, IItemStack product) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack stack : InputHelper.toStacks(ingredients)) {
            if (stack != null) {
                stacks.add(stack);
            }
            if (stack != null) continue;
            stacks.add(new ItemStack(Blocks.field_150350_a));
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(new MachineCarpenter.Recipe(packagingTime, InputHelper.toFluid(liquid), InputHelper.toStack(ingredient), new ShapedRecipeCustom(3, 3, (Object[])InputHelper.toStacks(ingredients), InputHelper.toStack(product)))));
    }

    public ShapedRecipeCustom convertToRecipeCustom() {
        return null;
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output, @Optional IIngredient liquid) {
        LinkedList<MachineCarpenter.Recipe> recipes = new LinkedList<MachineCarpenter.Recipe>();
        for (MachineCarpenter.Recipe recipe : MachineCarpenter.RecipeManager.recipes) {
            if (recipe == null || recipe.getCraftingResult() == null || !StackHelper.matches(output, InputHelper.toIItemStack(recipe.getCraftingResult()))) continue;
            if (liquid != null) {
                if (!StackHelper.matches(liquid, InputHelper.toILiquidStack(recipe.getLiquid()))) continue;
                recipes.add(recipe);
                continue;
            }
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<MachineCarpenter.Recipe> {
        public Remove(List<MachineCarpenter.Recipe> recipes) {
            super(Carpenter.name, MachineCarpenter.RecipeManager.recipes, recipes);
        }

        @Override
        protected String getRecipeInfo(MachineCarpenter.Recipe recipe) {
            return LogHelper.getStackDescription(recipe.getCraftingResult());
        }
    }

    private static class Add
    extends BaseListAddition<MachineCarpenter.Recipe> {
        public Add(MachineCarpenter.Recipe recipe) {
            super(Carpenter.name, MachineCarpenter.RecipeManager.recipes);
            this.recipes.add(recipe);
            if (recipe.getLiquid() != null) {
                ForestryHelper.addCarpenterRecipeFluids(recipe.getLiquid().getFluid());
            }
            if (!MachineCarpenter.RecipeManager.isBox((ItemStack)recipe.getBox())) {
                ForestryHelper.addCarpenterRecipeBox(recipe.getBox());
            }
        }

        @Override
        protected String getRecipeInfo(MachineCarpenter.Recipe recipe) {
            return LogHelper.getStackDescription(recipe.getCraftingResult());
        }
    }
}

