/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.forestry.handlers;

import forestry.api.recipes.ICentrifugeRecipe;
import forestry.factory.gadgets.MachineCentrifuge;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.WeightedItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Centrifuge")
public class Centrifuge {
    public static final String name = "Forestry Centrifuge";

    @ZenMethod
    public static void addRecipe(WeightedItemStack[] output, int timePerItem, IItemStack ingredient) {
        HashMap<ItemStack, Float> products = new HashMap<ItemStack, Float>();
        for (WeightedItemStack product : output) {
            products.put(InputHelper.toStack(product.getStack()), Float.valueOf(product.getChance()));
        }
        MineTweakerAPI.apply((IUndoableAction)new Add((ICentrifugeRecipe)new MachineCentrifuge.CentrifugeRecipe(timePerItem, InputHelper.toStack(ingredient), products)));
    }

    @ZenMethod
    @Deprecated
    public static void addRecipe(int timePerItem, IItemStack itemInput, IItemStack[] output, int[] chances) {
        HashMap<ItemStack, Float> products = new HashMap<ItemStack, Float>();
        int i = 0;
        for (IItemStack product : output) {
            products.put(InputHelper.toStack(product), Float.valueOf((float)chances[i] / 100.0f));
            ++i;
        }
        MineTweakerAPI.apply((IUndoableAction)new Add((ICentrifugeRecipe)new MachineCentrifuge.CentrifugeRecipe(timePerItem, InputHelper.toStack(itemInput), products)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        LinkedList<ICentrifugeRecipe> recipes = new LinkedList<ICentrifugeRecipe>();
        for (ICentrifugeRecipe recipe : MachineCentrifuge.RecipeManager.recipes) {
            if (recipe == null || !StackHelper.matches(input, InputHelper.toIItemStack(recipe.getInput()))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, input.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<ICentrifugeRecipe> {
        public Remove(List<ICentrifugeRecipe> recipes) {
            super(Centrifuge.name, MachineCentrifuge.RecipeManager.recipes, recipes);
        }

        @Override
        protected String getRecipeInfo(ICentrifugeRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getInput());
        }
    }

    private static class Add
    extends BaseListAddition<ICentrifugeRecipe> {
        public Add(ICentrifugeRecipe recipe) {
            super(Centrifuge.name, MachineCentrifuge.RecipeManager.recipes);
            this.recipes.add(recipe);
        }

        @Override
        protected String getRecipeInfo(ICentrifugeRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getInput());
        }
    }
}

