/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.forestry.handlers;

import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.factory.gadgets.MachineFermenter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import modtweaker2.utils.BaseMapAddition;
import modtweaker2.utils.BaseMapRemoval;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Fermenter")
public class Fermenter {
    public static final String name = "Forestry Fermenter";

    @ZenMethod
    public static void addRecipe(ILiquidStack fluidOutput, IItemStack resource, ILiquidStack fluidInput, int fermentationValue, float fluidOutputModifier) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new MachineFermenter.Recipe(InputHelper.toStack(resource), fermentationValue, fluidOutputModifier, InputHelper.toFluid(fluidOutput), InputHelper.toFluid(fluidInput))));
    }

    @Deprecated
    @ZenMethod
    public static void addRecipe(IItemStack resource, ILiquidStack fluidInput, int fermentationValue, float fluidOutputModifier, ILiquidStack fluidOutput) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new MachineFermenter.Recipe(InputHelper.toStack(resource), fermentationValue, fluidOutputModifier, InputHelper.toFluid(fluidOutput), InputHelper.toFluid(fluidInput))));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        LinkedList<MachineFermenter.Recipe> recipes = new LinkedList<MachineFermenter.Recipe>();
        for (MachineFermenter.Recipe recipe : MachineFermenter.RecipeManager.recipes) {
            if (recipe != null && recipe.resource != null && StackHelper.matches(input, InputHelper.toIItemStack(recipe.resource))) {
                recipes.add(recipe);
            }
            if (recipe == null || recipe.resource == null || !StackHelper.matches(input, InputHelper.toILiquidStack(recipe.liquid))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, input.toString()));
        }
    }

    @ZenMethod
    public static void addFuel(IItemStack item, int fermentPerCycle, int burnDuration) {
        MineTweakerAPI.apply((IUndoableAction)new AddFuel(new FermenterFuel(InputHelper.toStack(item), fermentPerCycle, burnDuration)));
    }

    @ZenMethod
    public static void removeFuel(IIngredient fermenterItem) {
        HashMap<ItemStack, FermenterFuel> fuelItems = new HashMap<ItemStack, FermenterFuel>();
        for (Map.Entry fuelItem : FuelManager.fermenterFuel.entrySet()) {
            if (fuelItem == null || !StackHelper.matches(fermenterItem, InputHelper.toIItemStack(((FermenterFuel)fuelItem.getValue()).item))) continue;
            fuelItems.put((ItemStack)fuelItem.getKey(), (FermenterFuel)fuelItem.getValue());
        }
        if (!fuelItems.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveFuel(fuelItems));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, fermenterItem.toString()));
        }
    }

    private static class RemoveFuel
    extends BaseMapRemoval<ItemStack, FermenterFuel> {
        public RemoveFuel(Map<ItemStack, FermenterFuel> recipes) {
            super(Fermenter.name, FuelManager.fermenterFuel, recipes);
        }

        @Override
        public String getRecipeInfo(Map.Entry<ItemStack, FermenterFuel> fuelEntry) {
            return LogHelper.getStackDescription(fuelEntry.getKey());
        }
    }

    private static class AddFuel
    extends BaseMapAddition<ItemStack, FermenterFuel> {
        public AddFuel(FermenterFuel fuelEntry) {
            super(Fermenter.name, FuelManager.fermenterFuel);
            this.recipes.put(fuelEntry.item, fuelEntry);
        }

        @Override
        public String getRecipeInfo(Map.Entry<ItemStack, FermenterFuel> fuelEntry) {
            return LogHelper.getStackDescription(fuelEntry.getKey());
        }
    }

    private static class Remove
    extends BaseListRemoval<MachineFermenter.Recipe> {
        public Remove(List<MachineFermenter.Recipe> recipes) {
            super(Fermenter.name, MachineFermenter.RecipeManager.recipes, recipes);
        }

        @Override
        public void apply() {
            Fluid fluid;
            boolean found;
            super.apply();
            Iterator iter = MachineFermenter.RecipeManager.recipeFluidInputs.iterator();
            while (iter.hasNext()) {
                found = false;
                fluid = (Fluid)iter.next();
                for (MachineFermenter.Recipe recipe : this.list) {
                    if (recipe == null || recipe.liquid == null || !recipe.liquid.getFluid().equals(fluid)) continue;
                    found = true;
                }
                if (found) continue;
                iter.remove();
            }
            iter = MachineFermenter.RecipeManager.recipeFluidOutputs.iterator();
            while (iter.hasNext()) {
                found = false;
                fluid = (Fluid)iter.next();
                for (MachineFermenter.Recipe recipe : this.list) {
                    if (recipe == null || recipe.output == null || !recipe.output.getFluid().equals(fluid)) continue;
                    found = true;
                }
                if (found) continue;
                iter.remove();
            }
        }

        @Override
        public void undo() {
            for (MachineFermenter.Recipe recipe : this.successful) {
                MachineFermenter.RecipeManager.recipeFluidInputs.add(recipe.liquid.getFluid());
                MachineFermenter.RecipeManager.recipeFluidOutputs.add(recipe.output.getFluid());
            }
            super.undo();
        }

        @Override
        public String getRecipeInfo(MachineFermenter.Recipe recipe) {
            return LogHelper.getStackDescription(recipe.output);
        }
    }

    private static class Add
    extends BaseListAddition<MachineFermenter.Recipe> {
        public Add(MachineFermenter.Recipe recipe) {
            super(Fermenter.name, MachineFermenter.RecipeManager.recipes);
            this.recipes.add(recipe);
        }

        @Override
        public void apply() {
            for (MachineFermenter.Recipe recipe : this.successful) {
                MachineFermenter.RecipeManager.recipeFluidInputs.add(recipe.liquid.getFluid());
                MachineFermenter.RecipeManager.recipeFluidOutputs.add(recipe.output.getFluid());
            }
            super.apply();
        }

        @Override
        public void undo() {
            Fluid fluid;
            boolean found;
            super.undo();
            Iterator iter = MachineFermenter.RecipeManager.recipeFluidInputs.iterator();
            while (iter.hasNext()) {
                found = false;
                fluid = (Fluid)iter.next();
                for (MachineFermenter.Recipe recipe : this.list) {
                    if (recipe == null || recipe.liquid == null || !recipe.liquid.getFluid().equals(fluid)) continue;
                    found = true;
                }
                if (found) continue;
                iter.remove();
            }
            iter = MachineFermenter.RecipeManager.recipeFluidOutputs.iterator();
            while (iter.hasNext()) {
                found = false;
                fluid = (Fluid)iter.next();
                for (MachineFermenter.Recipe recipe : this.list) {
                    if (recipe == null || recipe.output == null || !recipe.output.getFluid().equals(fluid)) continue;
                    found = true;
                }
                if (found) continue;
                iter.remove();
            }
        }

        @Override
        public String getRecipeInfo(MachineFermenter.Recipe recipe) {
            return LogHelper.getStackDescription(recipe.output);
        }
    }
}

