/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.forestry.handlers;

import forestry.factory.gadgets.MachineStill;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Still")
public class Still {
    public static final String name = "Forestry Still";

    @ZenMethod
    public static void addRecipe(int timePerUnit, ILiquidStack input, ILiquidStack output) {
        output.amount(output.getAmount() / 100);
        input.amount(input.getAmount() / 100);
        MineTweakerAPI.apply((IUndoableAction)new Add(new MachineStill.Recipe(timePerUnit, InputHelper.toFluid(input), InputHelper.toFluid(output))));
        MachineStill.RecipeManager.recipeFluidInputs.add(InputHelper.getFluid(input));
        MachineStill.RecipeManager.recipeFluidOutputs.add(InputHelper.getFluid(output));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack output, ILiquidStack input) {
        LinkedList<MachineStill.Recipe> recipes = new LinkedList<MachineStill.Recipe>();
        for (MachineStill.Recipe r : MachineStill.RecipeManager.recipes) {
            if (r == null || r.output == null || !StackHelper.matches((IIngredient)output, InputHelper.toILiquidStack(r.output))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<MachineStill.Recipe> {
        public Remove(List<MachineStill.Recipe> recipes) {
            super(Still.name, MachineStill.RecipeManager.recipes, recipes);
        }

        @Override
        public String getRecipeInfo(MachineStill.Recipe recipe) {
            return LogHelper.getStackDescription(recipe.output);
        }
    }

    private static class Add
    extends BaseListAddition<MachineStill.Recipe> {
        public Add(MachineStill.Recipe recipe) {
            super(Still.name, MachineStill.RecipeManager.recipes);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(MachineStill.Recipe recipe) {
            return LogHelper.getStackDescription(recipe.output);
        }
    }
}

