/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.forestry.handlers;

import forestry.core.utils.ShapedRecipeCustom;
import forestry.factory.gadgets.MachineFabricator;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.ThermionicFabricator")
public class ThermionicFabricator {
    public static final String nameSmelting = "Forestry Thermionic Fabricator (Smelting)";
    public static final String nameCasting = "Forestry Thermionic Fabricator (Casting)";

    @ZenMethod
    public static void addSmelting(IItemStack itemInput, int meltingPoint, int fluidOutput) {
        MineTweakerAPI.apply((IUndoableAction)new AddSmelting(new MachineFabricator.Smelting(InputHelper.toStack(itemInput), FluidRegistry.getFluidStack((String)"glass", (int)fluidOutput), meltingPoint)));
    }

    @ZenMethod
    public static void addCast(ILiquidStack fluidInput, IItemStack[][] ingredients, IItemStack plan, IItemStack product) {
        Object[] flatList = new ItemStack[9];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                flatList[i * 3 + j] = InputHelper.toStack(ingredients[i][j]);
            }
        }
        MineTweakerAPI.apply((IUndoableAction)new AddCast(new MachineFabricator.Recipe(InputHelper.toStack(plan), InputHelper.toFluid(fluidInput), new ShapedRecipeCustom(3, 3, flatList, InputHelper.toStack(product)))));
    }

    @ZenMethod
    public static void removeSmelting(IIngredient itemInput) {
        LinkedList<MachineFabricator.Smelting> recipes = new LinkedList<MachineFabricator.Smelting>();
        for (MachineFabricator.Smelting r : MachineFabricator.RecipeManager.smeltings) {
            if (r == null || r.getResource() == null || !StackHelper.matches(itemInput, InputHelper.toIItemStack(r.getResource()))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveSmelting(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", nameSmelting, itemInput.toString()));
        }
    }

    @ZenMethod
    public static void removeCasts(IIngredient product) {
        LinkedList<MachineFabricator.Recipe> recipes = new LinkedList<MachineFabricator.Recipe>();
        for (MachineFabricator.Recipe r : MachineFabricator.RecipeManager.recipes) {
            if (r == null || r.asIRecipe().func_77571_b() == null || !StackHelper.matches(product, InputHelper.toIItemStack(r.asIRecipe().func_77571_b()))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveCasts(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", nameSmelting, product.toString()));
        }
    }

    private static class RemoveCasts
    extends BaseListRemoval<MachineFabricator.Recipe> {
        public RemoveCasts(List<MachineFabricator.Recipe> recipes) {
            super(ThermionicFabricator.nameCasting, MachineFabricator.RecipeManager.recipes, recipes);
        }

        @Override
        public String getRecipeInfo(MachineFabricator.Recipe recipe) {
            return LogHelper.getStackDescription(recipe.asIRecipe().func_77571_b());
        }
    }

    private static class RemoveSmelting
    extends BaseListRemoval<MachineFabricator.Smelting> {
        public RemoveSmelting(List<MachineFabricator.Smelting> recipes) {
            super(ThermionicFabricator.nameSmelting, MachineFabricator.RecipeManager.smeltings, recipes);
        }

        @Override
        public String getRecipeInfo(MachineFabricator.Smelting recipe) {
            return LogHelper.getStackDescription(recipe.getResource());
        }
    }

    private static class AddCast
    extends BaseListAddition<MachineFabricator.Recipe> {
        public AddCast(MachineFabricator.Recipe recipe) {
            super(ThermionicFabricator.nameCasting, MachineFabricator.RecipeManager.recipes);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(MachineFabricator.Recipe recipe) {
            return LogHelper.getStackDescription(recipe.asIRecipe().func_77571_b());
        }
    }

    private static class AddSmelting
    extends BaseListAddition<MachineFabricator.Smelting> {
        public AddSmelting(MachineFabricator.Smelting recipe) {
            super(ThermionicFabricator.nameSmelting, MachineFabricator.RecipeManager.smeltings);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(MachineFabricator.Smelting recipe) {
            return LogHelper.getStackDescription(recipe.getResource());
        }
    }
}

