/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.railcraft.handlers;

import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import mods.railcraft.api.crafting.IRockCrusherRecipe;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.railcraft.RailcraftHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.railcraft.RockCrusher")
public class RockCrusher {
    public static final String name = "Railcraft Rock Crusher";

    @ZenMethod
    public static void addRecipe(IItemStack input, boolean matchDamage, boolean matchNBT, IItemStack[] output, double[] chances) {
        IRockCrusherRecipe recipe = RailcraftHelper.getRockCrusherRecipe(InputHelper.toStack(input), matchDamage, matchNBT);
        for (int i = 0; i < output.length; ++i) {
            recipe.addOutput(InputHelper.toStack(output[i]), (float)chances[i]);
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        LinkedList<IRockCrusherRecipe> recipes = new LinkedList<IRockCrusherRecipe>();
        for (IRockCrusherRecipe iRockCrusherRecipe : RailcraftHelper.crusher) {
            if (iRockCrusherRecipe.getInput() == null || !StackHelper.matches(input, InputHelper.toIItemStack(iRockCrusherRecipe.getInput()))) continue;
            recipes.add(iRockCrusherRecipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, input.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<IRockCrusherRecipe> {
        public Remove(List<IRockCrusherRecipe> recipes) {
            super("Rock Crusher", RailcraftHelper.crusher, recipes);
        }

        @Override
        public String getRecipeInfo(IRockCrusherRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getInput());
        }
    }

    private static class Add
    extends BaseListAddition<IRockCrusherRecipe> {
        public Add(IRockCrusherRecipe recipe) {
            super(RockCrusher.name, RailcraftHelper.crusher);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(IRockCrusherRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getInput());
        }
    }
}

