/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thaumcraft.handlers;

import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.thaumcraft.ThaumcraftHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.crafting.CrucibleRecipe;

@ZenClass(value="mods.thaumcraft.Crucible")
public class Crucible {
    public static final String name = "Thaumcraft Crucible";

    @ZenMethod
    public static void addRecipe(String key, IItemStack result, IIngredient catalyst, String aspects) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new CrucibleRecipe(key, InputHelper.toStack(result), InputHelper.toObject(catalyst), ThaumcraftHelper.parseAspects(aspects))));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        LinkedList<CrucibleRecipe> recipes = new LinkedList<CrucibleRecipe>();
        for (Object o : ThaumcraftApi.getCraftingRecipes()) {
            CrucibleRecipe r;
            if (!(o instanceof CrucibleRecipe) || (r = (CrucibleRecipe)o).getRecipeOutput() == null || !StackHelper.matches(output, InputHelper.toIItemStack(r.getRecipeOutput()))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<CrucibleRecipe> {
        public Remove(List<CrucibleRecipe> recipes) {
            super(Crucible.name, ThaumcraftApi.getCraftingRecipes(), recipes);
        }

        @Override
        protected String getRecipeInfo(CrucibleRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getRecipeOutput());
        }
    }

    private static class Add
    extends BaseListAddition<CrucibleRecipe> {
        public Add(CrucibleRecipe recipe) {
            super(Crucible.name, ThaumcraftApi.getCraftingRecipes());
            this.recipes.add(recipe);
        }

        @Override
        protected String getRecipeInfo(CrucibleRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getRecipeOutput());
        }
    }
}

