/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thermalexpansion.handlers;

import cofh.thermalexpansion.util.crafting.SmelterManager;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.ReflectionHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.thermalexpansion.ThermalHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.Smelter")
public class Smelter {
    public static final String name = "Thermal Expansion Smelter";

    @ZenMethod
    public static void addRecipe(int energy, IItemStack input, IItemStack input2, IItemStack output) {
        Smelter.addRecipe(energy, input, input2, output, null, 0);
    }

    @ZenMethod
    public static void addRecipe(int energy, IItemStack input, IItemStack input2, IItemStack output, IItemStack output2, int chance) {
        if (input == null || input2 == null || output == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        if (SmelterManager.recipeExists((ItemStack)InputHelper.toStack(input), (ItemStack)InputHelper.toStack(input2))) {
            LogHelper.logWarning(String.format("Duplicate %s Recipe found for %s and %s. Command ignored!", name, LogHelper.getStackDescription(InputHelper.toStack(input)), LogHelper.getStackDescription(InputHelper.toStack(input2))));
            return;
        }
        SmelterManager.RecipeSmelter recipe = ReflectionHelper.getInstance(ThermalHelper.smelterRecipe, InputHelper.toStack(input), InputHelper.toStack(input2), InputHelper.toStack(output), InputHelper.toStack(output2), chance, energy);
        if (recipe != null) {
            MineTweakerAPI.apply((IUndoableAction)new Add(recipe));
        } else {
            LogHelper.logError(String.format("Error while creating instance for %s recipe.", name));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input1, IIngredient input2) {
        LinkedList<SmelterManager.RecipeSmelter> recipes = new LinkedList<SmelterManager.RecipeSmelter>();
        for (SmelterManager.RecipeSmelter recipe : SmelterManager.getRecipeList()) {
            if (recipe == null || !StackHelper.matches(input1, InputHelper.toIItemStack(recipe.getPrimaryInput())) || !StackHelper.matches(input2, InputHelper.toIItemStack(recipe.getSecondaryInput()))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipes found for %s and %s.", name, input1.toString(), input2.toString()));
        }
    }

    @ZenMethod
    public static void refreshRecipes() {
        MineTweakerAPI.apply((IUndoableAction)new Refresh());
    }

    private static class Refresh
    implements IUndoableAction {
        private Refresh() {
        }

        public void apply() {
            SmelterManager.refreshRecipes();
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Refreshing Thermal Expansion Smelter recipes";
        }

        public void undo() {
        }

        public String describeUndo() {
            return "Ignoring undo of Thermal Expansion Smelter recipe refresh";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Remove
    extends BaseListRemoval<SmelterManager.RecipeSmelter> {
        public Remove(List<SmelterManager.RecipeSmelter> recipes) {
            super(Smelter.name, null, recipes);
        }

        @Override
        public void apply() {
            for (SmelterManager.RecipeSmelter recipe : this.recipes) {
                boolean removed = SmelterManager.removeRecipe((ItemStack)recipe.getPrimaryInput(), (ItemStack)recipe.getSecondaryInput());
                if (!removed) continue;
                this.successful.add(recipe);
            }
        }

        @Override
        public void undo() {
            for (SmelterManager.RecipeSmelter recipe : this.recipes) {
                SmelterManager.addRecipe((int)recipe.getEnergy(), (ItemStack)recipe.getPrimaryInput(), (ItemStack)recipe.getSecondaryInput(), (ItemStack)recipe.getPrimaryOutput(), (ItemStack)recipe.getSecondaryOutput(), (int)recipe.getSecondaryOutputChance());
            }
        }

        @Override
        protected boolean equals(SmelterManager.RecipeSmelter recipe, SmelterManager.RecipeSmelter otherRecipe) {
            return ThermalHelper.equals(recipe, otherRecipe);
        }

        @Override
        public String getRecipeInfo(SmelterManager.RecipeSmelter recipe) {
            return LogHelper.getStackDescription(recipe.getPrimaryOutput());
        }
    }

    private static class Add
    extends BaseListAddition<SmelterManager.RecipeSmelter> {
        public Add(SmelterManager.RecipeSmelter recipe) {
            super(Smelter.name, null);
            this.recipes.add(recipe);
        }

        @Override
        public void apply() {
            for (SmelterManager.RecipeSmelter recipe : this.recipes) {
                boolean applied = SmelterManager.addRecipe((int)recipe.getEnergy(), (ItemStack)recipe.getPrimaryInput(), (ItemStack)recipe.getSecondaryInput(), (ItemStack)recipe.getPrimaryOutput(), (ItemStack)recipe.getSecondaryOutput(), (int)recipe.getSecondaryOutputChance());
                if (!applied) continue;
                this.successful.add(recipe);
            }
        }

        @Override
        public void undo() {
            for (SmelterManager.RecipeSmelter recipe : this.successful) {
                SmelterManager.removeRecipe((ItemStack)recipe.getPrimaryInput(), (ItemStack)recipe.getSecondaryInput());
            }
        }

        @Override
        protected boolean equals(SmelterManager.RecipeSmelter recipe, SmelterManager.RecipeSmelter otherRecipe) {
            return ThermalHelper.equals(recipe, otherRecipe);
        }

        @Override
        public String getRecipeInfo(SmelterManager.RecipeSmelter recipe) {
            return LogHelper.getStackDescription(recipe.getPrimaryOutput());
        }
    }
}

