/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import ttftcuts.atg.ATGChunkManager;
import ttftcuts.atg.config.ATGBiomeList;
import ttftcuts.atg.config.configfiles.ATGMainConfig;
import ttftcuts.atg.gen.ATGBiomeManager;
import ttftcuts.atg.gen.ATGPerlin;
import ttftcuts.atg.structure.ATGMapGenRiver;

public class ATGChunkProvider
implements IChunkProvider {
    private World worldObj;
    private Random rand;
    private boolean useStructures;
    public long seed;
    private int sealevel;
    private ATGChunkManager manager;
    private BiomeGenBase[] biomesForGeneration;
    private MapGenBase caveGenerator = new MapGenCaves();
    private MapGenStronghold strongholdGenerator = new MapGenStronghold();
    private MapGenVillage villageGenerator = new MapGenVillage();
    private MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    private MapGenScatteredFeature scatteredFeatureGenerator = new MapGenScatteredFeature();
    private MapGenBase ravineGenerator = new MapGenRavine();
    private ATGMapGenRiver riverGenerator;
    private ATGPerlin[] noise;
    private NoiseGeneratorPerlin stoneNoise;
    private double[] stoneNoiseValues;

    public ATGChunkProvider(World world, long seedNum, boolean structures) {
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)this.strongholdGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)this.villageGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)this.mineshaftGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.scatteredFeatureGenerator = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)this.scatteredFeatureGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.ravineGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.riverGenerator = new ATGMapGenRiver();
        this.stoneNoiseValues = new double[256];
        this.worldObj = world;
        this.seed = seedNum;
        this.useStructures = structures;
        this.rand = new Random(this.seed);
        this.sealevel = 63;
        this.manager = (ATGChunkManager)this.worldObj.func_72959_q();
        this.noise = new ATGPerlin[20];
        this.noise[0] = new ATGPerlin(this.rand, 100.0, 10.0, 100.0);
        this.noise[1] = new ATGPerlin(this.rand, 200.0, 20.0, 200.0);
        this.noise[2] = new ATGPerlin(this.rand, 300.0, 30.0, 300.0);
        this.noise[3] = new ATGPerlin(this.rand, 400.0, 40.0, 400.0);
        this.noise[4] = new ATGPerlin(this.rand, 128.0, 128.0, 128.0);
        this.noise[5] = new ATGPerlin(this.rand, 64.0, 64.0, 64.0);
        this.noise[6] = new ATGPerlin(this.rand, 32.0, 32.0, 32.0);
        this.noise[7] = new ATGPerlin(this.rand, 16.0, 16.0, 16.0);
        this.noise[8] = new ATGPerlin(this.rand, 64.0, 64.0, 64.0);
        this.noise[9] = new ATGPerlin(this.rand, 20.0, 1.0, 20.0);
        this.stoneNoise = new NoiseGeneratorPerlin(this.rand, 4);
    }

    public ATGChunkManager getManager() {
        return this.manager;
    }

    private double[] getNoiseMix(int x, int y, int z) {
        int noiseHeight = 16;
        double[] data = new double[noiseHeight];
        for (int dy = 0; dy < noiseHeight; ++dy) {
            int ny = y + dy - noiseHeight / 2;
            double n1 = this.noise[0].noise(x, ny, z);
            double n2 = this.noise[1].noise(x, ny, z);
            double n3 = this.noise[2].noise(x, ny, z);
            double n4 = this.noise[3].noise(x, ny, z);
            double n5 = this.noise[4].noise(x, ny, z);
            double n6 = this.noise[5].noise(x, ny, z);
            double n7 = this.noise[6].noise(x, ny, z);
            double n8 = this.noise[7].noise(x, ny, z);
            double nc1 = (n1 * 5.0 + n2 * 3.0 + n3 + n4) * 0.1;
            double nc2 = (n5 * 3.0 + n6 * 13.0 + n7 * 3.0 + n8) * 0.05;
            data[dy] = (nc1 + nc2 * 3.0) * 0.25;
        }
        return data;
    }

    public ATGPerlin getNoiseGen(int id) {
        if (id < 0 || id >= this.noise.length) {
            id = 0;
        }
        return this.noise[id];
    }

    private void generateTerrain(int chunkX, int chunkY, Block[] data) {
        int height = data.length / 256;
        int[] rawdata = this.manager.getRawGenInts(chunkX * 16, chunkY * 16, 16, 16);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int gen = rawdata[x + z * 16];
                double[] noiseData = this.getNoiseMix(chunkX * 16 + x, gen, chunkY * 16 + z);
                int noiseHeight = noiseData.length;
                int biome = this.manager.func_76935_a((int)(chunkX * 16 + x), (int)(chunkY * 16 + z)).field_76756_M;
                double biomeNoiseFactor = 1.0;
                if (ATGBiomeManager.getMod(biome) != null) {
                    gen = ATGBiomeManager.getMod(biome).modify(this.worldObj, gen, this.rand, this.manager.getRawHeightDouble(chunkX * 16 + x, chunkY * 16 + z), chunkX * 16 + x, chunkY * 16 + z);
                    biomeNoiseFactor = ATGBiomeManager.getMod(biome).noiseFactor();
                }
                for (int y = 0; y < height; ++y) {
                    Block block = Blocks.field_150350_a;
                    double density = gen - y;
                    if ((double)y >= (double)gen - (double)noiseHeight * 0.5 && y < gen + noiseHeight / 2) {
                        double diff = 1.0 - (double)Math.abs(gen - y) / ((double)noiseHeight * 0.5);
                        double factor = diff * diff * (3.0 - 2.0 * diff);
                        double heightfactor = Math.min(1.5, (double)Math.max(0, y - (this.sealevel + 12)) / 60.0);
                        density += (noiseData[y - gen + noiseHeight / 2] * 255.0 * factor * heightfactor * heightfactor - 0.25) * biomeNoiseFactor;
                    }
                    if (y < 255) {
                        if (density > 0.0) {
                            block = ATGBiomeList.volcano.isPresent() && biome == ((BiomeGenBase)ATGBiomeList.volcano.get()).field_76756_M && y < gen - 1 && gen <= 231 ? Blocks.field_150343_Z : Blocks.field_150348_b;
                        } else if (ATGBiomeList.volcano.isPresent() && biome == ((BiomeGenBase)ATGBiomeList.volcano.get()).field_76756_M && y < 226) {
                            block = ATGMainConfig.genMagmaShafts.getBoolean(true) ? Blocks.field_150353_l : Blocks.field_150347_e;
                        } else if (y < this.sealevel) {
                            block = Blocks.field_150355_j;
                        }
                    }
                    data[x << 12 | z << 8 | y] = block;
                }
            }
        }
    }

    public Chunk func_73154_d(int chunkX, int chunkY) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkY * 132897987541L);
        Block[] data = new Block[65536];
        byte[] abyte = new byte[65536];
        this.generateTerrain(chunkX, chunkY, data);
        this.biomesForGeneration = this.manager.func_76933_b(this.biomesForGeneration, chunkX * 16, chunkY * 16, 16, 16);
        this.replaceBlocksForBiome(chunkX, chunkY, data, abyte, this.biomesForGeneration);
        if (ATGMainConfig.genRivers.getBoolean(true)) {
            this.riverGenerator.func_151539_a(this, this.worldObj, chunkX, chunkY, data);
        }
        this.caveGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkY, data);
        this.ravineGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkY, data);
        if (this.useStructures) {
            this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkY, data);
            this.villageGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkY, data);
            this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkY, data);
            this.scatteredFeatureGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkY, data);
        }
        Chunk chunk = new Chunk(this.worldObj, data, abyte, chunkX, chunkY);
        byte[] chunkBiomes = chunk.func_76605_m();
        for (int i = 0; i < chunkBiomes.length; ++i) {
            chunkBiomes[i] = (byte)this.biomesForGeneration[i].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    public Chunk func_73158_c(int var1, int var2) {
        return this.func_73154_d(var1, var2);
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void replaceBlocksForBiome(int chunkx, int chunkz, Block[] blocks, byte[] abyte, BiomeGenBase[] biomes) {
        ChunkProviderEvent.ReplaceBiomeBlocks event = new ChunkProviderEvent.ReplaceBiomeBlocks((IChunkProvider)this, chunkx, chunkz, blocks, abyte, biomes, this.worldObj);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        double scale = 0.03125;
        this.stoneNoiseValues = this.stoneNoise.func_151599_a(this.stoneNoiseValues, (double)(chunkx * 16), (double)(chunkz * 16), 16, 16, scale * 2.0, scale * 2.0, 1.0);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BiomeGenBase biome = biomes[z + x * 16];
                biome.func_150573_a(this.worldObj, this.rand, blocks, abyte, chunkx * 16 + x, chunkz * 16 + z, this.stoneNoiseValues[z + x * 16]);
            }
        }
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int chunkX, int chunkZ) {
        int popZ;
        int popY;
        int popX;
        BlockSand.field_149832_M = true;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        BiomeGenBase biome = this.worldObj.func_72807_a(x + 16, z + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long rand1 = this.rand.nextLong() / 2L * 2L + 1L;
        long rand2 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * rand1 + (long)chunkZ * rand2 ^ this.worldObj.func_72905_C());
        boolean hasVillage = false;
        if (ATGMainConfig.genRivers.getBoolean(true)) {
            this.riverGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(par1IChunkProvider, this.worldObj, this.rand, chunkX, chunkZ, hasVillage));
        if (this.useStructures) {
            this.mineshaftGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
            hasVillage = this.villageGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
            this.strongholdGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
            this.scatteredFeatureGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
        }
        if (TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE) && !hasVillage && this.rand.nextInt(4) == 0) {
            popX = x + this.rand.nextInt(16) + 8;
            popY = this.rand.nextInt(256);
            popZ = z + this.rand.nextInt(16) + 8;
            new WorldGenLakes(Blocks.field_150355_j).func_76484_a(this.worldObj, this.rand, popX, popY, popZ);
        }
        if (TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA) && !hasVillage && this.rand.nextInt(8) == 0) {
            popX = x + this.rand.nextInt(16) + 8;
            popY = this.rand.nextInt(this.rand.nextInt(248) + 8);
            popZ = z + this.rand.nextInt(16) + 8;
            if (popY < this.sealevel || this.rand.nextInt(10) == 0) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a(this.worldObj, this.rand, popX, popY, popZ);
            }
        }
        boolean doGen = TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON);
        for (int i = 0; doGen && i < 8; ++i) {
            popX = x + this.rand.nextInt(16) + 8;
            if (!new WorldGenDungeons().func_76484_a(this.worldObj, this.rand, popX, popY = this.rand.nextInt(256), popZ = z + this.rand.nextInt(16) + 8)) continue;
        }
        biome.func_76728_a(this.worldObj, this.rand, x, z);
        if (TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biome, (int)(x + 8), (int)(z + 8), (int)16, (int)16, (Random)this.rand);
        }
        x += 8;
        z += 8;
        doGen = TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE);
        for (popX = 0; doGen && popX < 16; ++popX) {
            for (popZ = 0; popZ < 16; ++popZ) {
                popY = this.worldObj.func_72874_g(x + popX, z + popZ);
                if (this.worldObj.func_72884_u(popX + x, popY - 1, popZ + z)) {
                    this.worldObj.func_147465_d(popX + x, popY - 1, popZ + z, Blocks.field_150432_aD, 0, 2);
                }
                if (!this.worldObj.func_147478_e(popX + x, popY, popZ + z, true)) continue;
                this.worldObj.func_147465_d(popX + x, popY, popZ + z, Blocks.field_150431_aC, 0, 2);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(par1IChunkProvider, this.worldObj, this.rand, chunkX, chunkZ, hasVillage));
        BlockSand.field_149832_M = false;
    }

    public boolean func_73151_a(boolean var1, IProgressUpdate var2) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "ATGLevelSource";
    }

    public List func_73155_a(EnumCreatureType type, int x, int y, int z) {
        BiomeGenBase biome = this.worldObj.func_72807_a(x, z);
        return type == EnumCreatureType.monster && this.scatteredFeatureGenerator.func_143030_a(x, y, z) ? this.scatteredFeatureGenerator.func_82667_a() : biome.func_76747_a(type);
    }

    public ChunkPosition func_147416_a(World world, String type, int x, int y, int z) {
        return "Stronghold".equals(type) && this.strongholdGenerator != null ? this.strongholdGenerator.func_151545_a(world, x, y, z) : null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int x, int z) {
        if (this.useStructures) {
            this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.worldObj, x, z, (Block[])null);
            this.villageGenerator.func_151539_a((IChunkProvider)this, this.worldObj, x, z, (Block[])null);
            this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.worldObj, x, z, (Block[])null);
            this.scatteredFeatureGenerator.func_151539_a((IChunkProvider)this, this.worldObj, x, z, (Block[])null);
        }
    }

    public boolean func_73156_b() {
        return false;
    }

    public void func_104112_b() {
    }
}

