/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.config.configfiles;

import java.io.File;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import ttftcuts.atg.ATG;
import ttftcuts.atg.utils.ModFinder;

public class ATGBiomeConfig {
    public static Configuration config;
    public static Property[] biomeChance;
    public static Property[] generate;
    public static Property[] villages;

    public static void init(File configfile) {
        config = new Configuration(configfile, null, true);
        try {
            config.load();
        }
        catch (Exception e) {
            ATG.logger.info("Failed to load biome config!");
        }
    }

    public static void postInit() {
        BiomeGenBase[] biomeList = BiomeGenBase.func_150565_n();
        for (int i = 0; i < 256; ++i) {
            if (biomeList[i] == null) continue;
            BiomeGenBase biome = biomeList[i];
            String savename = ATGBiomeConfig.getSaveNameFromBiome(biome);
            ATGBiomeConfig.biomeChance[biome.field_76756_M] = config.get(savename, "OccuranceMultiplier", 1.0);
            ATGBiomeConfig.generate[biome.field_76756_M] = config.get(savename, "Enable", true);
            ATGBiomeConfig.villages[biome.field_76756_M] = config.get(savename, "AllowVillages", true);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static String getSaveNameFromBiome(BiomeGenBase b) {
        return ModFinder.idFromObject(b) + "." + b.field_76791_y;
    }

    public static BiomeGenBase getBiomeFromSaveName(String savename) {
        String[] saveparts = savename.split("[.]");
        BiomeGenBase[] biomeList = BiomeGenBase.func_150565_n();
        for (int i = 0; i < biomeList.length; ++i) {
            String mod;
            BiomeGenBase biome = biomeList[i];
            if (biome == null || !saveparts[0].equals(mod = ModFinder.idFromObject(biome)) || !saveparts[1].equals(biome.field_76791_y)) continue;
            return biome;
        }
        return null;
    }

    static {
        biomeChance = new Property[256];
        generate = new Property[256];
        villages = new Property[256];
    }
}

