/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.gen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.biome.BiomeGenBase;
import ttftcuts.atg.biome.ATGBiomeGroup;
import ttftcuts.atg.gen.ATGBiomeMod;

public class ATGBiomeManager {
    protected static Map<String, ATGBiomeGroup> landGroups = new HashMap<String, ATGBiomeGroup>();
    protected static Map<String, ATGBiomeGroup> seaGroups = new HashMap<String, ATGBiomeGroup>();
    protected static Map<String, ATGBiomeGroup> coastGroups = new HashMap<String, ATGBiomeGroup>();
    private static ATGBiomeMod[] genMods = new ATGBiomeMod[256];
    public static boolean sendGroupAssignmentEvents = false;

    public static ATGBiomeGroup addBiomeGroup(Map<String, ATGBiomeGroup> grouplist, String name, double temp, double rainfall, double height, double minHeight, double maxHeight, long salt, boolean generate) {
        if (grouplist.containsKey(name)) {
            return null;
        }
        ATGBiomeGroup group = new ATGBiomeGroup(name, temp, rainfall, height, minHeight, maxHeight, salt, generate);
        return ATGBiomeManager.addBiomeGroup(grouplist, group);
    }

    public static ATGBiomeGroup addBiomeGroup(Map<String, ATGBiomeGroup> grouplist, ATGBiomeGroup group) {
        if (grouplist.containsKey(group.name)) {
            return null;
        }
        grouplist.put(group.getName(), group);
        return group;
    }

    public static ATGBiomeGroup addLandGroup(String name, double temp, double rainfall, double height, double minHeight, double maxHeight, long salt, boolean generate) {
        return ATGBiomeManager.addBiomeGroup(landGroups, name, temp, rainfall, height, minHeight, maxHeight, salt, generate);
    }

    public static ATGBiomeGroup addSeaGroup(String name, double temp, double rainfall, double height, double minHeight, double maxHeight, long salt, boolean generate) {
        return ATGBiomeManager.addBiomeGroup(seaGroups, name, temp, rainfall, height, minHeight, maxHeight, salt, generate);
    }

    public static ATGBiomeGroup addCoastGroup(String name, double temp, double rainfall, double height, double minHeight, double maxHeight, long salt, boolean generate) {
        return ATGBiomeManager.addBiomeGroup(coastGroups, name, temp, rainfall, height, minHeight, maxHeight, salt, generate);
    }

    public static ATGBiomeGroup addLandGroup(String name, double temp, double rainfall, double height, long salt, boolean generate) {
        return ATGBiomeManager.addBiomeGroup(landGroups, name, temp, rainfall, height, 0.0, 1.0, salt, generate);
    }

    public static ATGBiomeGroup addSeaGroup(String name, double temp, double rainfall, double height, long salt, boolean generate) {
        return ATGBiomeManager.addBiomeGroup(seaGroups, name, temp, rainfall, height, 0.0, 1.0, salt, generate);
    }

    public static ATGBiomeGroup addCoastGroup(String name, double temp, double rainfall, double height, long salt, boolean generate) {
        return ATGBiomeManager.addBiomeGroup(coastGroups, name, temp, rainfall, height, 0.0, 1.0, salt, generate);
    }

    public static ATGBiomeGroup addLandGroup(String name, double temp, double rainfall, double height, double minHeight, double maxHeight, long salt) {
        return ATGBiomeManager.addBiomeGroup(landGroups, name, temp, rainfall, height, minHeight, maxHeight, salt, true);
    }

    public static ATGBiomeGroup addSeaGroup(String name, double temp, double rainfall, double height, double minHeight, double maxHeight, long salt) {
        return ATGBiomeManager.addBiomeGroup(seaGroups, name, temp, rainfall, height, minHeight, maxHeight, salt, true);
    }

    public static ATGBiomeGroup addCoastGroup(String name, double temp, double rainfall, double height, double minHeight, double maxHeight, long salt) {
        return ATGBiomeManager.addBiomeGroup(coastGroups, name, temp, rainfall, height, minHeight, maxHeight, salt, true);
    }

    public static ATGBiomeGroup addLandGroup(String name, double temp, double rainfall, double height, long salt) {
        return ATGBiomeManager.addBiomeGroup(landGroups, name, temp, rainfall, height, 0.0, 1.0, salt, true);
    }

    public static ATGBiomeGroup addSeaGroup(String name, double temp, double rainfall, double height, long salt) {
        return ATGBiomeManager.addBiomeGroup(seaGroups, name, temp, rainfall, height, 0.0, 1.0, salt, true);
    }

    public static ATGBiomeGroup addCoastGroup(String name, double temp, double rainfall, double height, long salt) {
        return ATGBiomeManager.addBiomeGroup(coastGroups, name, temp, rainfall, height, 0.0, 1.0, salt, true);
    }

    public static ATGBiomeGroup addLandGroup(ATGBiomeGroup group) {
        return ATGBiomeManager.addBiomeGroup(landGroups, group);
    }

    public static ATGBiomeGroup addSeaGroup(ATGBiomeGroup group) {
        return ATGBiomeManager.addBiomeGroup(seaGroups, group);
    }

    public static ATGBiomeGroup addCoastGroup(ATGBiomeGroup group) {
        return ATGBiomeManager.addBiomeGroup(coastGroups, group);
    }

    public static ATGBiomeGroup land(String name) {
        return landGroups.get(name);
    }

    public static ATGBiomeGroup sea(String name) {
        return seaGroups.get(name);
    }

    public static ATGBiomeGroup coast(String name) {
        return coastGroups.get(name);
    }

    public static ATGBiomeGroup getGroupFromName(String name) {
        ATGBiomeGroup group = ATGBiomeManager.land(name);
        if (group != null) {
            return group;
        }
        group = ATGBiomeManager.sea(name);
        if (group != null) {
            return group;
        }
        return ATGBiomeManager.coast(name);
    }

    public static Map<String, ATGBiomeGroup> land() {
        return landGroups;
    }

    public static Map<String, ATGBiomeGroup> sea() {
        return seaGroups;
    }

    public static Map<String, ATGBiomeGroup> coast() {
        return coastGroups;
    }

    public static ATGBiomeMod setBiomeMod(BiomeGenBase biome, ATGBiomeMod modifier) {
        if (biome != null) {
            return ATGBiomeManager.setBiomeMod(biome.field_76756_M, modifier);
        }
        return modifier;
    }

    public static ATGBiomeMod setBiomeMod(int biomeID, ATGBiomeMod modifier) {
        if (biomeID > 0) {
            ATGBiomeManager.genMods[biomeID] = modifier;
        }
        return modifier;
    }

    public static ATGBiomeMod addBiomeMod(BiomeGenBase biome) {
        ATGBiomeMod m = ATGBiomeManager.getMod(biome);
        if (m != null) {
            return m;
        }
        return ATGBiomeManager.setBiomeMod(biome, new ATGBiomeMod());
    }

    public static ATGBiomeMod addBiomeMod(int biomeID) {
        ATGBiomeMod m = ATGBiomeManager.getMod(biomeID);
        if (m != null) {
            return m;
        }
        return ATGBiomeManager.setBiomeMod(biomeID, new ATGBiomeMod());
    }

    public static ATGBiomeMod getMod(int biomeID) {
        return genMods[biomeID];
    }

    public static ATGBiomeMod getMod(BiomeGenBase biome) {
        return ATGBiomeManager.getMod(biome.field_76756_M);
    }

    public static List<String> getGroupsFromBiome(BiomeGenBase biome) {
        int i;
        ArrayList<String> groups = new ArrayList<String>();
        for (i = 0; i < landGroups.size(); ++i) {
            if (!landGroups.get(i).containsBiome(biome) || groups.contains(ATGBiomeManager.landGroups.get((Object)Integer.valueOf((int)i)).name)) continue;
            groups.add(ATGBiomeManager.landGroups.get((Object)Integer.valueOf((int)i)).name);
        }
        for (i = 0; i < coastGroups.size(); ++i) {
            if (!coastGroups.get(i).containsBiome(biome) || groups.contains(ATGBiomeManager.coastGroups.get((Object)Integer.valueOf((int)i)).name)) continue;
            groups.add(ATGBiomeManager.coastGroups.get((Object)Integer.valueOf((int)i)).name);
        }
        for (i = 0; i < seaGroups.size(); ++i) {
            if (!seaGroups.get(i).containsBiome(biome) || groups.contains(ATGBiomeManager.seaGroups.get((Object)Integer.valueOf((int)i)).name)) continue;
            groups.add(ATGBiomeManager.seaGroups.get((Object)Integer.valueOf((int)i)).name);
        }
        return groups;
    }
}

