/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.structure;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import ttftcuts.atg.gen.ATGHeightNoise;
import ttftcuts.atg.utils.ATGUtils;

public class ATGComponentRiverSection
extends StructureComponent {
    static double waterForVisible = 4.0;
    static double waterForMaxSize = 60.0;
    static double maxRadius = 4.0;
    ATGHeightNoise heightMap;
    int x;
    int z;
    double slopeDir;
    double height;
    double water;
    Random rand;
    int iteration;
    int groundHeight;
    ATGComponentRiverSection parent;
    static int checkSize = 3;
    static int checkWidth = 1 + checkSize * 2;
    double[] heightData;

    public ATGComponentRiverSection() {
    }

    public ATGComponentRiverSection(int par1, Random rand, int x, int z, ATGHeightNoise heightmap, ATGComponentRiverSection previous, int iteration) {
        super(par1);
        this.x = x;
        this.z = z;
        this.rand = rand;
        this.heightMap = heightmap;
        this.field_74887_e = new StructureBoundingBox(x - 1, 253, z - 1, x + 1, 255, z + 1);
        this.field_74885_f = 0;
        this.iteration = iteration;
        this.groundHeight = -1;
        if (previous != null) {
            this.parent = previous;
            this.water = this.parent.water;
        } else {
            this.parent = null;
            this.water = 0.1;
        }
        this.water += 0.5;
        this.heightData = new double[checkWidth * checkWidth];
        for (int iz = 0; iz < checkWidth; ++iz) {
            for (int ix = 0; ix < checkWidth; ++ix) {
                this.heightData[iz * ATGComponentRiverSection.checkWidth + ix] = this.heightMap.getHeight(ix + x - checkSize, iz + z - checkSize);
            }
        }
        this.height = this.heightData[checkSize * checkWidth + checkSize];
        this.slopeDir = this.getFlowDirection(1);
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
        int x = this.field_74887_e.func_78881_e();
        int z = this.field_74887_e.func_78891_g();
        if (this.groundHeight < 0) {
            for (int top = 255; top >= 0; --top) {
                if (!ATGUtils.blockIsGround(world.func_147439_a(x, top, z))) continue;
                this.groundHeight = top;
                this.field_74887_e.func_78886_a(0, top - 254, 0);
                break;
            }
        }
        int xdiff = 1;
        if (this.parent != null) {
            xdiff = this.x - this.parent.x;
        }
        int zdiff = 1;
        if (this.parent != null) {
            zdiff = this.z - this.parent.z;
        }
        int steps = Math.max(Math.abs(xdiff), Math.abs(zdiff));
        double dx = (double)(xdiff / steps) * 0.5;
        double dz = (double)(zdiff / steps) * 0.5;
        for (int i = 0; i < steps * 2; ++i) {
            int stepz;
            int y;
            int stepx = (int)Math.round((double)this.x - (double)i * dx + 0.5);
            Block block = world.func_147439_a(stepx, y = ATGUtils.getTopBlockOrLiquid(world, stepx, stepz = (int)Math.round((double)this.z - (double)i * dz + 0.5)), stepz);
            if (block == Blocks.field_150355_j) {
                this.water += 5.0;
            }
            if (!(this.water > waterForVisible)) continue;
            double blobFactor = (this.water - waterForVisible) / (waterForMaxSize - waterForVisible);
            double blobRadius = maxRadius * blobFactor;
            int diff = (int)Math.ceil(blobRadius);
            for (int bz = -diff; bz <= diff; ++bz) {
                for (int bx = -diff; bx <= diff; ++bx) {
                    int dy;
                    double dist = Math.sqrt(bx * bx + bz * bz);
                    if (!(dist < blobRadius) || !box.func_78890_b(stepx + bx, this.func_74862_a(0), stepz + bz)) continue;
                    for (dy = ATGUtils.getTopBlockOrLiquid(world, stepx + bx, stepz + bz); !ATGUtils.blockIsNonsolidNotWater(world, stepx + bx, dy + 1, stepz + bz) && dy < 255; ++dy) {
                    }
                    if (box.func_78890_b(stepx + bx, dy, stepz + bz)) {
                        world.func_147449_b(stepx + bx, dy, stepz + bz, Blocks.field_150355_j);
                    }
                    if (!box.func_78890_b(stepx + bx, dy - 1, stepz + bz)) continue;
                    world.func_147449_b(stepx + bx, dy - 1, stepz + bz, Blocks.field_150355_j);
                }
            }
        }
        return true;
    }

    public void func_74861_a(StructureComponent component, List list, Random rand) {
    }

    public ATGComponentRiverSection getNextPiece() {
        double prev;
        double diff;
        if (this.iteration > 200) {
            System.out.println("Iterations maxed at " + this.x + "," + this.z);
            return null;
        }
        double angle = this.slopeDir;
        if (this.parent != null && Math.abs(diff = ATGUtils.angleDiff(angle, prev = this.parent.slopeDir)) >= 1.0471975511965976) {
            angle = prev;
        }
        int offset = 3;
        int ox = (int)Math.round(Math.sin(angle) * (double)offset);
        int oz = (int)Math.round(Math.cos(angle) * (double)offset);
        double thisHeight = this.height;
        double height = this.heightMap.getHeight(this.x + ox, this.z + oz);
        if (ATGHeightNoise.getInt(height) > 60 && thisHeight > height) {
            return new ATGComponentRiverSection(0, this.rand, this.x + ox, this.z + oz, this.heightMap, this, this.iteration + 1);
        }
        return null;
    }

    private double getHeightData(int x, int y) {
        return this.heightData[y * checkWidth + x];
    }

    private double getFlowDirection(int sampleRadius) {
        int x = checkSize;
        int y = checkSize;
        double sx = this.getHeightData(x + 1, y) - this.getHeightData(x - 1, y);
        double sy = this.getHeightData(x, y + 1) - this.getHeightData(x, y - 1);
        return Math.atan2(-sx, -sy);
    }

    protected void func_143012_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_143011_b(NBTTagCompound nbttagcompound) {
    }
}

