/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.tml.data.chest;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dmillerw.tml.TooMuchLoot;
import dmillerw.tml.data.LootLoadingMode;
import dmillerw.tml.data.chest.ChestLootCategory;
import dmillerw.tml.data.chest.ChestLootItem;
import dmillerw.tml.helper.GsonHelper;
import dmillerw.tml.helper.LogHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import org.apache.commons.lang3.ArrayUtils;

public class ChestLootLoader {
    public static FilenameFilter FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File file, String s) {
            return s.endsWith(".json");
        }
    };

    public static HashMap<String, ChestGenHooks> copyLootTable(Map<String, ChestGenHooks> lootTable) {
        HashMap newLootTable = Maps.newHashMap();
        try {
            for (String key : lootTable.keySet()) {
                ChestGenHooks old = lootTable.get(key);
                ArrayList copiedList = Lists.newArrayList();
                for (WeightedRandomChestContent chestContent : (List)TooMuchLoot.contents.get(old)) {
                    copiedList.add(new WeightedRandomChestContent(chestContent.field_76297_b.func_77946_l(), chestContent.field_76295_d, chestContent.field_76296_e, chestContent.field_76292_a));
                }
                newLootTable.put(key, new ChestGenHooks(key, copiedList.toArray(new WeightedRandomChestContent[copiedList.size()]), old.getMin(), old.getMax()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newLootTable;
    }

    public static void restoreCachedLootTable() {
        try {
            TooMuchLoot.chestInfo.set(ChestGenHooks.class, ChestLootLoader.copyLootTable((Map)TooMuchLoot.chestInfo.get(ChestGenHooks.class)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void generateFiles(File generationDir, String ... categories) {
        if (!generationDir.exists()) {
            generationDir.mkdirs();
        }
        if (categories == null || categories.length == 0) {
            categories = TooMuchLoot.chestGenCategories;
        } else if (ArrayUtils.contains((Object[])TooMuchLoot.chestGenCategories, (Object)categories[0])) {
            return;
        }
        for (String key : categories) {
            try {
                File file = new File(generationDir, key + ".json");
                if (!file.exists()) {
                    file.createNewFile();
                }
                ChestLootCategory lootCategory = ChestLootCategory.fromChestGenHooks(key);
                lootCategory.loading_mode = null;
                for (ChestLootItem lootItem : lootCategory.loot) {
                    if (!lootItem.nbt.func_82582_d()) continue;
                    lootItem.nbt = null;
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(GsonHelper.gson.toJson((Object)lootCategory, ChestLootCategory.class).getBytes());
                fileOutputStream.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void loadFiles(File scanDir) {
        HashMultimap toAdd = HashMultimap.create();
        HashMultimap toRemove = HashMultimap.create();
        HashMap tempMap = Maps.newHashMap();
        for (File file : scanDir.listFiles(FILTER)) {
            LogHelper.logParse(file.getName());
            try {
                ChestLootCategory lootCategory = ((ChestLootCategory)GsonHelper.gson.fromJson(new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])), Charset.defaultCharset()), ChestLootCategory.class)).checkCountValues();
                for (ChestLootItem chestLootItem : lootCategory.loot) {
                    chestLootItem.checkCountValues();
                }
                if (lootCategory.loading_mode == LootLoadingMode.OVERRIDE) {
                    if (!tempMap.containsKey(lootCategory.category)) {
                        LogHelper.logOverride(lootCategory.category);
                        tempMap.put(lootCategory.category, lootCategory.toChestGenHooks());
                        continue;
                    }
                    LogHelper.logOverrideError(lootCategory.category, file.getName());
                    continue;
                }
                if (lootCategory.loading_mode == LootLoadingMode.ADD) {
                    for (ChestLootItem lootItem : lootCategory.loot) {
                        toAdd.put((Object)lootCategory.category, (Object)lootItem.toChestContent());
                    }
                    continue;
                }
                if (lootCategory.loading_mode != LootLoadingMode.REMOVE) continue;
                for (ChestLootItem lootItem : lootCategory.loot) {
                    toRemove.put((Object)lootCategory.category, (Object)lootItem.toItemStack());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            if (!tempMap.isEmpty()) {
                ((HashMap)TooMuchLoot.chestInfo.get(ChestGenHooks.class)).putAll(tempMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (Map.Entry entry : toAdd.entries()) {
            LogHelper.logAddition((String)entry.getKey(), ((WeightedRandomChestContent)entry.getValue()).field_76297_b.func_82833_r());
            ChestGenHooks.getInfo((String)((String)entry.getKey())).addItem((WeightedRandomChestContent)entry.getValue());
        }
        for (Map.Entry entry : toRemove.entries()) {
            LogHelper.logRemoval((String)entry.getKey(), ((ItemStack)entry.getValue()).func_82833_r());
            ChestGenHooks.getInfo((String)((String)entry.getKey())).removeItem((ItemStack)entry.getValue());
        }
    }
}

