/*
 * Decompiled with CFR 0.152.
 */
package unwrittenfun.minecraft.immersiveintegration.blocks;

import blusunrize.immersiveengineering.common.util.Utils;
import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.redstone.IBundledRedstoneProvider;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import unwrittenfun.minecraft.immersiveintegration.ImmersiveIntegration;
import unwrittenfun.minecraft.immersiveintegration.blocks.BlockWireConnector;
import unwrittenfun.minecraft.immersiveintegration.tiles.TileRedstoneWireConnector;

@Optional.Interface(modid="ComputerCraft", iface="dan200.computercraft.api.redstone.IBundledRedstoneProvider")
public class BlockRedstoneWireConnector
extends BlockWireConnector
implements IBundledRedstoneProvider {
    public static IIcon inputIcon;

    protected BlockRedstoneWireConnector(String key) {
        super(key);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        inputIcon = iconRegister.func_94245_a(this.func_149641_N() + "Input");
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileRedstoneWireConnector();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!Utils.isHammer((ItemStack)player.func_71045_bC())) {
            return false;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileRedstoneWireConnector) {
            TileRedstoneWireConnector wireConnector = (TileRedstoneWireConnector)tileEntity;
            if (player.func_70093_af()) {
                wireConnector.incrementChannel();
            } else {
                wireConnector.toggleMode();
            }
        }
        return true;
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileRedstoneWireConnector) {
            ((TileRedstoneWireConnector)tileEntity).wireNetwork.updateValues();
        }
        super.func_149695_a(world, x, y, z, block);
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        if (ForgeDirection.OPPOSITES[side] == world.func_72805_g(x, y, z)) {
            return this.func_149709_b(world, x, y, z, side);
        }
        return 0;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TileRedstoneWireConnector wireConnector;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileRedstoneWireConnector && (wireConnector = (TileRedstoneWireConnector)tileEntity).isOutput()) {
            return wireConnector.getPowerOutput();
        }
        return 0;
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        return tileEntity instanceof TileRedstoneWireConnector && ((TileRedstoneWireConnector)tileEntity).isOutput();
    }

    @Optional.Method(modid="ComputerCraft")
    public int getBundledRedstoneOutput(World world, int x, int y, int z, int side) {
        TileRedstoneWireConnector connector;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (side == world.func_72805_g(x, y, z) && tileEntity instanceof TileRedstoneWireConnector && (connector = (TileRedstoneWireConnector)tileEntity).isOutput()) {
            byte[] values = connector.wireNetwork.channelValues;
            int total = 0;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] <= 0) continue;
                total |= 1 << i;
            }
            ImmersiveIntegration.log.info((Object)total);
            return total;
        }
        return -1;
    }
}

