/*
 * Decompiled with CFR 0.152.
 */
package unwrittenfun.minecraft.immersiveintegration.multiblocks;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import unwrittenfun.minecraft.immersiveintegration.blocks.IIBlocks;
import unwrittenfun.minecraft.immersiveintegration.tiles.IMultiblockTile;

public class MultiblockIndustrialCokeOven
implements MultiblockHandler.IMultiblock {
    public static ItemStack[][][] blockStructure = new ItemStack[4][5][7];
    public static ItemStack[][][][] targetStructure = new ItemStack[4][5][7][2];

    public boolean isBlockTrigger(Block b, int meta) {
        return b == IIBlocks.steelDecoration && meta == 1;
    }

    public boolean createStructure(World world, int x, int y, int z, int side, EntityPlayer player) {
        int ddx;
        int ddz;
        int dy;
        int dx;
        int dz;
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        for (dz = -4; dz <= 0; ++dz) {
            for (dx = -3; dx <= 3; ++dx) {
                for (dy = -1; dy <= 2; ++dy) {
                    ddz = dz * direction.offsetZ;
                    ddx = dx;
                    if (direction.offsetX != 0) {
                        ddz = dx;
                        ddx = dz * direction.offsetX;
                    }
                    ItemStack targetItem = blockStructure[dy + 1][dz + 4][dx + 3];
                    if (world.func_147439_a(x + ddx, y + dy, z + ddz) == ((ItemBlock)targetItem.func_77973_b()).field_150939_a && world.func_72805_g(x + ddx, y + dy, z + ddz) == targetItem.func_77960_j()) continue;
                    return false;
                }
            }
        }
        for (dz = -4; dz <= 0; ++dz) {
            for (dx = -3; dx <= 3; ++dx) {
                for (dy = -1; dy <= 2; ++dy) {
                    ddz = dz * direction.offsetZ;
                    ddx = dx;
                    if (direction.offsetX != 0) {
                        ddz = dx;
                        ddx = dz * direction.offsetX;
                    }
                    int axis = 0;
                    if (direction.offsetX != 0) {
                        axis = 1;
                    }
                    ItemStack targetItem = targetStructure[dy + 1][dz + 4][dx + 3][axis];
                    Block targetBlock = ((ItemBlock)targetItem.func_77973_b()).field_150939_a;
                    if (world.func_147439_a(x + ddx, y + dy, z + ddz) == targetBlock) {
                        world.func_72921_c(x + ddx, y + dy, z + ddz, targetItem.func_77960_j(), 3);
                    } else {
                        world.func_147465_d(x + ddx, y + dy, z + ddz, targetBlock, targetItem.func_77960_j(), 3);
                    }
                    TileEntity tileEntity = world.func_147438_o(x + ddx, y + dy, z + ddz);
                    if (!(tileEntity instanceof IMultiblockTile)) continue;
                    IMultiblockTile multiblock = (IMultiblockTile)tileEntity;
                    multiblock.setOffset(new int[]{ddx, dy, ddz, direction.ordinal()});
                    multiblock.setReplaced(blockStructure[dy + 1][dz + 4][dx + 3].func_77946_l());
                    multiblock.setFormed(true);
                }
            }
        }
        return true;
    }

    public ItemStack[][][] getStructureManual() {
        return blockStructure;
    }

    public ItemStack[] getTotalMaterials() {
        return new ItemStack[]{new ItemStack(IIBlocks.steelDecoration, 70, 0), new ItemStack(IIBlocks.steelDecoration, 60, 1), new ItemStack(IIBlocks.steelDecoration, 10, 2)};
    }

    static {
        for (int h = 0; h < 4; ++h) {
            for (int l = 0; l < 5; ++l) {
                for (int w = 0; w < 7; ++w) {
                    MultiblockIndustrialCokeOven.blockStructure[h][l][w] = h == 0 && (w == 0 || w == 2 || w == 4 || w == 6) && (l == 0 || l == 4) || h == 1 && (w == 0 || w == 6) && l == 2 ? new ItemStack(IIBlocks.steelDecoration, 1, 2) : (w == 1 || w == 3 || w == 5 ? new ItemStack(IIBlocks.steelDecoration, 1, 1) : new ItemStack(IIBlocks.steelDecoration, 1, 0));
                    if (h == 1 && l == 2 && w == 3) {
                        MultiblockIndustrialCokeOven.targetStructure[h][l][w][0] = new ItemStack((Block)IIBlocks.industrialCokeOven, 1, 1);
                        MultiblockIndustrialCokeOven.targetStructure[h][l][w][1] = new ItemStack((Block)IIBlocks.industrialCokeOven, 1, 2);
                        continue;
                    }
                    MultiblockIndustrialCokeOven.targetStructure[h][l][w][0] = new ItemStack((Block)IIBlocks.industrialCokeOven, 1, 3);
                    MultiblockIndustrialCokeOven.targetStructure[h][l][w][1] = new ItemStack((Block)IIBlocks.industrialCokeOven, 1, 3);
                }
            }
        }
    }
}

