/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.button;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import java.util.List;
import net.minecraft.client.Minecraft;

public class CycleButton<T extends Enum<T>>
extends IconButton {
    private final T[] modes;
    private T mode;

    public CycleButton(IGuiScreen gui, int id, int x, int y, Class<T> enumClass) {
        super(gui, id, x, y, null);
        this.modes = (Enum[])enumClass.getEnumConstants();
        this.setMode(this.modes[0]);
    }

    public boolean func_146116_c(Minecraft par1Minecraft, int par2, int par3) {
        boolean result = super.func_146116_c(par1Minecraft, par2, par3);
        if (result) {
            this.nextMode();
        }
        return result;
    }

    @Override
    public boolean mousePressedButton(Minecraft mc, int x, int y, int button) {
        boolean result;
        boolean bl = result = button == 1 && super.checkMousePress(mc, x, y);
        if (result) {
            this.prevMode();
        }
        return result;
    }

    private void nextMode() {
        this.setMode(this.modes[(((Enum)this.mode).ordinal() + 1) % this.modes.length]);
    }

    private void prevMode() {
        int ord = ((Enum)this.mode).ordinal() - 1;
        if (ord < 0) {
            ord = this.modes.length - 1;
        }
        this.setMode(this.modes[ord]);
    }

    public void setMode(T newMode) {
        if (this.mode == newMode) {
            return;
        }
        this.mode = newMode;
        List<String> tooltip = ((ICycleEnum)this.mode).getTooltipLines();
        this.setToolTip(tooltip.toArray(new String[tooltip.size()]));
        this.icon = ((ICycleEnum)this.mode).getIcon();
    }

    public T getMode() {
        return this.mode;
    }

    public static interface ICycleEnum {
        public IWidgetIcon getIcon();

        public List<String> getTooltipLines();
    }
}

