/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.api.lanterntype;

import glenn.gasesframework.api.ItemKey;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;

public class LanternType {
    private static final HashMap<ItemKey, LanternType> lanternTypesByItemIn = new HashMap();
    private static final HashMap<String, LanternType> lanternTypesByName = new HashMap();
    public boolean isRegistered = false;
    public Block block;
    public final String name;
    public final float lightLevel;
    public final String textureName;
    public ItemKey itemOut;
    public final LanternType expirationLanternType;
    public final int expirationRate;
    private final HashSet<ItemKey> itemIn = new HashSet();

    public static LanternType getLanternTypeByItemIn(ItemKey itemMapping) {
        return lanternTypesByItemIn.get(itemMapping);
    }

    public static LanternType getLanternTypeByName(String name) {
        return lanternTypesByName.get(name);
    }

    public static LanternType[] getAllLanternTypes() {
        LanternType[] res = new LanternType[lanternTypesByName.size()];
        int i = 0;
        for (LanternType value : lanternTypesByName.values()) {
            res[i++] = value;
        }
        return res;
    }

    public LanternType(String name, float lightLevel, String textureName, ItemKey itemOut, LanternType expirationLanternType, int expirationRate) {
        this.name = name;
        this.lightLevel = lightLevel;
        this.textureName = textureName;
        this.itemOut = itemOut;
        this.expirationLanternType = expirationLanternType;
        this.expirationRate = expirationRate;
        this.map();
    }

    private void map() {
        LanternType prev = LanternType.getLanternTypeByName(this.name);
        if (prev != null) {
            throw new RuntimeException("A lantern type with name " + this.name + " attempted to override a lantern type with the same name");
        }
        lanternTypesByName.put(this.name, this);
    }

    public LanternType setInOut() {
        return this.addItemIn(this.itemOut);
    }

    public LanternType addItemIn(ItemKey item) {
        if (lanternTypesByItemIn.containsKey(item)) {
            throw new RuntimeException("A lantern type with name " + this.name + " attempted to override itemIn " + item);
        }
        lanternTypesByItemIn.put(item, this);
        this.itemIn.add(item);
        return this;
    }

    public boolean accepts(ItemKey item) {
        return this.itemIn.contains(item);
    }

    public ItemKey[] getAllAcceptedItems() {
        ItemKey[] res = new ItemKey[this.itemIn.size()];
        int i = 0;
        for (ItemKey item : this.itemIn) {
            res[i++] = item;
        }
        return res;
    }

    public Block tweakLanternBlock(Block block) {
        return block;
    }

    public boolean expires() {
        return this.expirationRate > 0;
    }

    public String getUnlocalizedName() {
        return "gf_lantern." + this.name;
    }
}

